package com.freemud.springbootdemo;

import com.alibaba.fastjson.support.spring.FastJsonpHttpMessageConverter4;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.converter.HttpMessageConverter;

@SpringBootApplication
@ComponentScan(basePackages = "com.freemud, cn.freemud")
@MapperScan(basePackages = "com.freemud.demo.mapper")
public class SpringbootDemoApplication {

	public static void main(String[] args) {
		SpringApplication.run(SpringbootDemoApplication.class, args);
	}

	@Bean
	public HttpMessageConverter getConverter(){
		return new FastJsonpHttpMessageConverter4();
	}
}
