#!/bin/bash

#服务名称 jar包名称
server_name="orderService-1.0"
# 配置环境
env="pro"
# 服务端口
server_port=7788

# JVMFLAGS JVM参数可以在这里设置
JVMFLAGS="-server -Xms2048M -Xmx2048M"

export PATH=$PATH:/usr/local/java/bin/

SPRINGBOOT_HOME="${BASH_SOURCE-$0}"
SPRINGBOOT_HOME="$(dirname "${SPRINGBOOT_HOME}")"
SPRINGBOOT_HOME="$(cd "${SPRINGBOOT_HOME}"; pwd)"


if [ $2 ];then
    server_name=$2
fi

if [ $3 ];then
    env=$3
fi

echo $server_name-----------$JVMFLAGS-----------$env------$server_port-------$SPRINGBOOT_HOME

function stop(){
    for i in `seq 1 4`;do
        echo "stop times:"+$i
        boot_id=`ps -ef |grep java |grep $server_name |grep $server_port|grep -v grep |awk '{print $2}'`
        count=`ps -ef |grep java |grep $server_name |grep $server_port|grep -v grep |wc -l`
        # echo $count

        if (( $count != 0 && $i == 1 )) ; then
            echo "stop......"
            kill  $boot_id
            sleep 3s
        elif (( $count != 0 && $i==4 )); then
            kill -9 $boot_id
        elif (( $count != 0 )); then
            sleep 3s
        else
            echo "========= stoped"
            break

        fi
    done
}

function start(){

    count=`ps -ef |grep java |grep $server_name |grep $server_port|grep -v grep |wc -l`
    echo $count

    if [ $count != 0 ] ; then
            echo "Server is running ..."
        else
            echo “Server starting ... ”$server_name
            nohup java $JVMFLAGS  -jar $SPRINGBOOT_HOME/current/$server_name.jar --spring.profiles.active=$env --server.port=$server_port >/dev/null &

    fi

}

case $1 in
    start)
        start
    ;;
    restart)
        stop
        start
    ;;
    stop)
        stop
    ;;
    *)
        echo "Usage: {start|stop|restart}" >&2
esac



