package com.freemud.demo.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.concurrent.TimeUnit;

//import org.apache.commons.lang3.StringUtils;

/**
 * Created by chenwenshun on 2018/9/4.
 */
@Component
public class RedisUitl{

    @Autowired
    private RedisTemplate redisTemplate;

    public RedisTemplate getRedisTemplate(){
        return redisTemplate;
    }

    public void setEx(String key, Object value, int expire, TimeUnit timeUnit){
        redisTemplate.opsForValue().set(key, value,expire,timeUnit);
    }

    public <T> T get(String key){
        return (T)redisTemplate.opsForValue().get(key);
    }

}
