package com.freemud.demo.util;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.TimeUnit;

/**
 * Created by chenwenshun on 2018/9/4.
 */

public abstract class RedisCache<T> {

    @Autowired
    protected RedisUitl redisUitl;

    /**
     * 获取缓存
     * @param key
     * @param clazz
     * @return
     */
    public  T getCache(Object key, Class<T> clazz){
        String redisKey = getRedisKey(clazz.getName(), key);
        T value = redisUitl.get(redisKey);
        if (value != null){
            return value;
        }

        value = searchDB(key);
        if (value == null){
            redisUitl.setEx(redisKey, value,30, TimeUnit.SECONDS);

        }else {
            redisUitl.setEx( redisKey,value, getExprie(), TimeUnit.SECONDS);
        }

        return value;
    }

    /**
     * 更新缓存
     * @param key
     * @param value
     */
    public void setCache(Object key, T value){
        redisUitl.setEx( getRedisKey(value.getClass().getName(), key),value, getExprie(), TimeUnit.SECONDS);
    }


    public abstract  T searchDB(Object key);

    public abstract int getExprie();

    private String getRedisKey(String keyPrefix, Object key){

        return keyPrefix+"_"+key.toString();
    }



}
