/**
 * 
 */
package com.freemud.demo.service;

import com.freemud.demo.dto.DictDataDto;
import com.freemud.demo.dto.DictTypeDto;
import com.freemud.demo.dto.PageReq;
import com.freemud.demo.dto.PageData;
import com.freemud.demo.model.TDictData;
import com.freemud.demo.model.TDictType;

import java.util.List;
import java.util.Map;

/**
 * 数据字典
 * 
 * @author chenwenshun
 * 
 */
 public interface IDictTypeService {
	/** 根据id取得数据字典 */
	 TDictType loadDictById(long dictTypeId);

	/** 根据cd取得数据字典 */
	TDictType loadDictByCd(String dictTypeCd);

	/** 根据cd取得数据字典 */
	DictDataDto loadDictDataByCd(String dictTypeCd, String dictCd, boolean onlyEnable);

	/** 保存 */
	TDictType saveDict(DictTypeDto dto);

	/** 批量保存字典列表 */
	 void saveDatas(List<DictDataDto> dictDataDtos);

	/** 删除 */
	 void deleteDict(long dictTypeId);
	/** 删除子表记录 */
	 void deleteDictData(long dictDataId);

	/** 翻页查询 */
	 PageData<DictTypeDto> findPageDict(PageReq page);

	/** 根据主表cd获取数据列表 */
	 List<DictDataDto> loadDatasByTypeCd(String dictTypeCd, boolean onlyEnable);



	/** 根据dictTypeCd取得数据map，用于填充下拉框 */
	 Map<String, String> loadDataMap(String dictTypeCd);
}
