package com.freemud.demo.cache;

import com.freemud.demo.dto.DictDataDto;
import com.freemud.demo.dto.DictTypeDto;
import com.freemud.demo.mapper.TDictDataMapper;
import com.freemud.demo.mapper.TDictTypeMapper;
import com.freemud.demo.model.TDictData;
import com.freemud.demo.model.TDictType;
import com.freemud.demo.util.RedisCache;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * Created by chenwenshun on 2018/11/7.
 */
@Component
public class DictRedisCache extends RedisCache<DictTypeDto> {

    @Autowired
    TDictTypeMapper dictTypeMapper;

    @Autowired
    TDictDataMapper dictDataMapper;

    @Override
    public DictTypeDto searchDB(Object key) {
        DictTypeDto dictTypeDto = new DictTypeDto();
        TDictType dictType = dictTypeMapper.selectByPrimaryKey(key);
        if (dictType == null){
            return null;
        }
        BeanUtils.copyProperties(dictType, dictTypeDto);
        List<TDictData> dictDataList = dictDataMapper.getByDictTypeId(dictType.getId());
        if (dictDataList.isEmpty()){
            return dictTypeDto;
        }
        List<DictDataDto> dictDataDtos = dictDataList.stream()
                .map(d -> {
                    DictDataDto dictDataDto = new DictDataDto();
                    BeanUtils.copyProperties(d, dictDataDto);
                    return dictDataDto;
                })
                .collect(Collectors.toList());

        dictTypeDto.setDictDataDtos(dictDataDtos);

        return dictTypeDto;
    }


    @Override
    public int getExprie() {
        return 60*60*24;//24小时
    }

}
