package com.freemud.springbootdemo.controller;

import com.freemud.demo.dto.*;
import com.freemud.demo.service.IDictTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Created by chenwenshun on 2018/11/2.
 */
@RestController
@RequestMapping(value = "/dict",produces = "application/json")
public class DictController {

    @Autowired
    IDictTypeService dictTypeService;

    @PostMapping("/page")
    public ResDto page(@RequestBody PageReq pageReq){
        PageData<DictTypeDto> pageData = dictTypeService.findPageDict(pageReq);

        return new ResDto(pageData);
    }


    @GetMapping( value = "/dictDatas/{dictTypeCd}")
    public ResDto dictDatas(@PathVariable String dictTypeCd){
        List<DictDataDto> list = this.dictTypeService.loadDatasByTypeCd(dictTypeCd,true);
        return new ResDto(list);

    }

    @GetMapping("/dictData/{dictTypeCd}/{dictCd}")
    public ResDto<DictDataDto> dictData(@PathVariable String dictTypeCd ,@PathVariable String dictCd){
        DictDataDto dictDataDto = this.dictTypeService.loadDictDataByCd(dictTypeCd,dictCd,true);
        return new ResDto<>(dictDataDto);
    }


}
