#include <iostream>
#include <fstream> 
#include <pthread.h>
#include "JsonModule.h"
#include "SocketModule.h"
#include "../utility/utility.h"
#include "../utility/zini.h"
#include "SQLiteModule.h"

#define ELPP_NO_DEFAULT_LOG_FILE
#include "../3rdParty/easylogging/easylogging++.h"

INITIALIZE_EASYLOGGINGPP

void logRolloutHandler(const char* filename, std::size_t size)
{
    /// 备份日志  
    //std::string strLogPath = GetProcDir();
    //strLogPath.append(filename);

    std::stringstream ss;
    ss << "mv " << filename << " "<<filename<<"_bk";
    LOG(INFO)<<"备份日志："<<ss.str().c_str();
    system(ss.str().c_str());
}


int main()
{
    el::Loggers::addFlag(el::LoggingFlag::StrictLogFileSizeCheck);
    std::string strBinPath = GetProcDir();
    std::string strLogPath(strBinPath.data()); 
    strLogPath.append("log.conf");
    el::Configurations conf(strLogPath.data());
    /// 设置全部logger的配置  
    el::Loggers::reconfigureAllLoggers(conf);
    /// 注册回调函数  
    el::Helpers::installPreRollOutCallback(logRolloutHandler);

    LOG(INFO)<<"日志测试";

    //---------ini test-------------
    std::string strIniPath(strBinPath.data());  
    strIniPath.append("config.ini");
    std::string ip = ZIni::readString("SYS","ip", "",strIniPath.c_str());
    LOG(INFO)<<"读取配置文件ip:"<<ip.data();
    //------------end---------------
    
    //---------- json test----------
    // std::string json = GetTestJson(100,"test data","123456789");
    // LOG(INFO)<<"生成JSON" <<json.data();
    
    // LOG(INFO)<<"JSON解析";
    // parseJson(json.data());
    JsonModule jsonMod;
    orderObj obj;
    productAttr product;
    product.pro.source="123";
    productSpec spec;
    spec.name="只";
    product.vecSpec.push_back(spec);
    obj.vecProducts.push_back(product);

    std::string orderInfo = jsonMod.convertToNewOrderJson(obj);
    LOG(INFO)<<"订单信息转换成JSON:"<<orderInfo.data();
    //------------end---------------

    //---------- pthread test ---------
    LOG(INFO)<<"启动SOCKET线程";
    pthread_t printId;
    int ret = pthread_create(&printId, NULL, FunSocketServer, NULL);
    //---------- end ------------------

    //---------- sqlite test-----------
    SQLite sqlite;
    sqlite.initSQLite(); 
    sqlite.insert("insert into fmTest(fm_id, statusCode,msg,prompt,fm_open_id,total_amount,paid_total_amount,invoice_amount,incentives_amount)\
                   values('aabbcc',111,'abc',123,'cba',1,1,1,1)");
    sqlite.query("select * from fmTest");
    sqlite.update("update fmTest set statusCode=200 where fm_id='aabbcc'");
    sqlite.query("select * from fmTest");
    sqlite.remove("delete from fmTest where fm_id='aabbcc'");
    sqlite.query("select * from fmTest");
    sqlite.closeSQLite();

    //-----------end------------------
    char pStr[20];
    std::cin>>pStr;
    return 0;
}

