#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include "SocketModule.h"
#include "../3rdParty/easylogging/easylogging++.h"

#define SOCKET_ERROR            (-1)
#define LISTEN_PORT              23775
#define BUFFER_SIZE             1024*10 //接收数据缓冲区大小

bool g_exit = false;
//socket 数据接收
//返回值   成功：接收长度
//         失败：  -1 
int socketRecvData(char * recvBuf, int bufSize, int socket_fd)
{
    int rcvedLength = 0;
    int rcvFlag = 0; //firstly, to rcv header
    int needLength = sizeof(FMSOCKHEADER);
    int rlt = 0;

    FMSOCKHEADER headx;
    char * pcRcvBufer = (char *)(&headx);

    while(0 < needLength)
    {
        //接收并打印客户端数据
        int length = recv(socket_fd, pcRcvBufer + rcvedLength, needLength, 0);
        if (0 < length)
        {
            needLength -= length;
            rcvedLength += length;

            if (0 == needLength)
            {
                if (0 == rcvFlag)
                {
                    //header rcved complete
                    rcvFlag = 1;//to rcv payload

                    int flag = headx.flag;
                    int len  = headx.len;
                    int ver  = headx.ver;

                    //need to check payloadLength is valid or not
                    if(len > bufSize)
                    {
                        rlt = -1;
                        LOG(ERROR)<<"socket recv 接收数据长度大于接收缓冲区："<<len;
                        break;
                    }
                    needLength = len;
                    pcRcvBufer = recvBuf;
                    rcvedLength = 0;
                    continue;
                }
                else
                {
                    //payload rcved complete
                    rlt = rcvedLength;
                    break;
                }
            }
        }
        else if(length == 0)
        {
            //socket error
            rlt = -1;
            LOG(ERROR)<<"socket recv 返回值:"<<length;
            break;
        }
    }
    return rlt;
}

//通过 sockClient 发送数据
int socketSendData(const char * sendBuf, int socket_fd)
{
    int toSendLength = strlen(sendBuf);
    char * pcSendBuf = (char *)sendBuf;
    int curSendLength = 0;
    int rlt=0;

    char* m_pFmPackage = new char[toSendLength + sizeof(FMSOCKHEADER)];
    FMSOCKHEADER header = { 0, 0, 0 };
    header.flag = 0x4d46;
    header.len = toSendLength;
    header.ver = 0x1;

    memcpy(m_pFmPackage, &header, sizeof(FMSOCKHEADER));
    memcpy(m_pFmPackage+sizeof(FMSOCKHEADER), pcSendBuf, toSendLength);
    toSendLength = toSendLength + sizeof(FMSOCKHEADER);

    while(curSendLength < toSendLength)
    {
        int res = send(socket_fd, pcSendBuf + curSendLength, toSendLength - curSendLength, 0);

        if(res == SOCKET_ERROR)
        {
            LOG(ERROR)<<"发送数据给fm服务端失败！";
            rlt=-1;
            break;
        }

        curSendLength += res;
    }
    if(curSendLength != toSendLength)
    {
        rlt=-1;
        LOG(ERROR)<<"socket数据发送不完整！";
    }
    return rlt;
}

//SOCKET服务线程
void *FunSocketServer(void* lpParamter)
{     
    LOG(INFO)<<"SOCKET SERVER"; 
    int socket_fd, connect_fd;
    struct sockaddr_in servaddr;
    char* pRecvBuf = new char[BUFFER_SIZE];       //打印数据接收区
    int nRecvLen = 0;

    int nErrCode = 0;

    //初始化Socket  
    if((socket_fd = socket(AF_INET, SOCK_STREAM, 0)) == -1 ){  
        LOG(ERROR)<<"create socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    //初始化  
    memset(&servaddr, 0, sizeof(servaddr));  
    servaddr.sin_family = AF_INET;  
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);//IP地址设置成INADDR_ANY,让系统自动获取本机的IP地址。  
    servaddr.sin_port = htons(LISTEN_PORT);      //设置的端口为LISTEN_PORT  
  
    // 设置套接字选项避免地址使用错误  
    int flag = 1;
    if ((setsockopt(socket_fd, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag)))<0)
    {  
        LOG(ERROR)<<"setsockopt failed";
        exit(0);
    } 

    //将本地地址绑定到所创建的套接字上  
    if( bind(socket_fd, (struct sockaddr*)&servaddr, sizeof(servaddr)) == -1){  
        LOG(ERROR)<<"bind socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    //开始监听是否有客户端连接  
    if( listen(socket_fd, 10) == -1){  
        LOG(ERROR)<<"listen socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    LOG(INFO)<<"======waiting for client's request======";

    while(!g_exit){  
        //阻塞直到有客户端连接，不然多浪费CPU资源。  
        if( (connect_fd = accept(socket_fd, (struct sockaddr*)NULL, NULL)) == -1){  
            LOG(ERROR)<<"accept socket error:"<<strerror(errno)<<" errno:"<<errno;  
            continue;  
        }  
        //接受客户端传过来的数据  
        int rlt = socketRecvData(pRecvBuf, BUFFER_SIZE, connect_fd);
        if (rlt > 0)
        {
            pRecvBuf[rlt] = '\0';
            //
            LOG(INFO)<<"打印请求："<<pRecvBuf;


            //std::string strReturnJson = GetTakeawayResultJson(statusCode,msg.data(),"");
            //发送返回数据                
            //int result = socketSendData(strReturnJson.data(), connect_fd);
            //LOG(INFO)<<"外卖发送处理结果："<<strReturnJson.c_str();

            close(connect_fd);
        }  
    }  
    close(socket_fd);
    delete[] pRecvBuf;
}
