#include <iostream>
#include <fstream>
#include <pthread.h>
#include "JsonModule.h"
#include "SocketModule.h"
#include "../utility/utility.h"
#include "../utility/zini.h"
#include "SQLiteModule.h"

#define ELPP_NO_DEFAULT_LOG_FILE
#include "../3rdParty/easylogging/easylogging++.h"

INITIALIZE_EASYLOGGINGPP

std::string g_init_data;

std::string ods_ip;
std::string pos_ip = "127.0.0.1";
int ods_push_port;
int ods_recv_port;
int client_listen_port;
int pos_listen_port;

void logRolloutHandler(const char* filename, std::size_t size)
{
    /// 备份日志
    //std::string strLogPath = GetProcDir();
    //strLogPath.append(filename);

    std::stringstream ss;
    ss << "mv " << filename << " "<<filename<<"_bk";
    LOG(INFO)<<"备份日志："<<ss.str().c_str();
    system(ss.str().c_str());
}

void* listen_pos_func(void* arg)  
{
    TCPServer server;
    JsonModule jsonTool;

    if( server.doListen(client_listen_port) )
    {
        LOG(INFO) << "监听端口: [" << client_listen_port << "] 成功";
    }else
    {
        LOG(INFO) << "监听端口: [" << client_listen_port << "] 失败";
    }

    while(true)
    {
        TCPClient pos;

        std::string posRequestData;
        std::string requestOdsData;
        std::string responseData;

        if( server.accept(pos) )
        {
            if( pos.receive(posRequestData) )
            {
                // 如果为初始化请求则通过长连接socket发送
                if( jsonTool.isInitData(posRequestData) )
                {
                    if( jsonTool.checkInitData(posRequestData, pos_listen_port) )
                    {
                        g_init_data = posRequestData;
                        jsonTool.getPosResponseData(100, "successful!", responseData);
                    }else
                    {
                        jsonTool.getPosResponseData(101, "invalid initdata!", responseData);
                    }
                }else
                {
                    // 将POS请求数据转换为中台可接受数据格式
                    if( jsonTool.convertDataPos2Ods(posRequestData, requestOdsData) )
                    {
                        // 同步阻塞发送到ODS并等待返回
                        TCPClient ods;
                        if( ods.connect(ods_recv_port, ods_ip.c_str()) )
                        {
                            if( ods.send(RequestOdsData) )
                            {
                                std::string tmp;
                                if( ods.receive(tmp) )
                                {
                                    jsonTool.getPosResponseData(tmp, responseData);
                                }else
                                {
                                    jsonTool.getPosResponseData(101, "receive data from [ODS] failed!", responseData);
                                }
                            }else
                            {
                                jsonTool.getPosResponseData(101, "send data to [ODS] failed!", responseData);
                            }

                            ods.close();
                        }else
                        {
                            jsonTool.getPosResponseData(101, "connect [ODS] failed!", responseData);
                        }
                    }else
                    {
                        jsonTool.getPosResponseData(101, "convert data to [ODS] format failed!", responseData);
                    }
                }

                // TODO待加入重试机制
                pos.send(responseData);
                pos.close();
            }else
            {
                LOG(INFO) << "接收POS推送消息失败";
            }
        }else
        {
            LOG(INFO) << "接收POS连接失败";
        }
    }
}


int main()
{	
    signal(SIGPIPE, SIG_IGN);
	
    // 初始化日志
    el::Loggers::addFlag(el::LoggingFlag::StrictLogFileSizeCheck);
    std::string strBinPath = GetProcDir();
    std::string strLogPath(strBinPath.data());
    strLogPath.append("log.conf");
    el::Configurations conf(strLogPath.data());
    /// 设置全部logger的配置
    el::Loggers::reconfigureAllLoggers(conf);
    /// 注册回调函数
    el::Helpers::installPreRollOutCallback(logRolloutHandler);

    LOG(INFO)<<"---------程序启动---------";

    // 读取配置文件信息
    std::string strIniPath(strBinPath.data());
    strIniPath.append("config.ini");

    ods_ip = ZIni::readString("ODS","ip", "", strIniPath.c_str());
    ods_push_port = ZIni::readInt("ODS", "pushPort", 0, strIniPath.c_str());
    ods_recv_port = ZIni::readInt("ODS", "recvPort", 0, strIniPath.c_str());

    pos_ip = ZIni::readString("POS","ip", "", strIniPath.c_str());
    pos_listen_port = ZIni::readInt("POS","port", 0, strIniPath.c_str());

    client_listen_port = ZIni::readInt("SYS", "port", 0, strIniPath.c_str());

    LOG(INFO) << "[ODS]ip地址: " << ods_ip.data()
              << "-推送端口: " << ods_push_port
              << "-监听端口: " << ods_recv_port;
    LOG(INFO) << "[CLIENT]监听端口: " << client_listen_port;
    LOG(INFO) << "[POS]ip地址: " << pos_ip
              << "-监听端口: " << pos_listen_port;
    //end
    
    // 监听POS请求的线程
    pthread_t listen_pos_id;

    /*创建 listen_pos 线程*/
    if(pthread_create(&listen_pos_id,NULL,listen_pos_func,NULL))
        LOG(INFO) << "创建listen_pos线程失败";

    TCPClient ods;
    JsonModule jsonTool;

    while(true)
    {
        std::string odsPushData;
        std::string pushPosData;
        std::string responseData;

        // 判断是否成功连接ODS
        if( !ods.isValid() )
        {
            if( ods.doConnect(ods_push_port, ods_ip.c_str()) )
            {
                LOG(INFO) << "连接ODS成功";

                // 注册socket信息
                while(true)
                {
                    if(!g_init_data.empty())
                    {
                        if( ods.send(g_init_data) )
                        {
                            break;
                        }
                    }
                    usleep(500);
                    continue;
                }
            }else
            {
                continue;
                usleep(800);
            }
        }

        if( ods.receive(odsPushData) )
        {
            if( jsonTool.convertDataOds2Pos(odsPushData, pushPosData) )
            {
                TCPClient pos;
                if( pos.connect(pos_listen_port, pos_ip.c_str()) )
                {
                    if( pos.send(pushPosData) )
                    {
                        std::string tmp;
                        if( pos.receive(tmp) )
                        {
                            jsonTool.getOdsResponseData(tmp, odsPushData, responseData);
                        }else
                        {
                            jsonTool.getOdsResponseData(101, "receive data from [POS] failed!", responseData);
                        }
                    }else
                    {
                        jsonTool.getOdsResponseData(101, "send data to [POS] failed!", responseData);
                    }

                    pos.close();
                }else
                {
                    jsonTool.getOdsResponseData(101, "connect [POS] failed!", responseData);
                }
            }else
            {
                jsonTool.getOdsResponseData(101, "convert data to [POS] format failed!", responseData);
            }

            // TODO待加入重试机制
            ods.send(responseData);
        }else
        {
            LOG(INFO) << "接收ODS推送消息失败";
        }
    }

    return 0;
}

