#ifndef JSON_MODULE_H
#define JSON_MODULE_H

#include "../base/CommonStruct.h"
#include "../base/BaseDefine.h"
//std::string GetTestJson(const int statuscode,const char* msg,const char* orderid);

//void parseJson(const char* json);
class JsonModule
{
public:
    JsonModule();
    ~JsonModule();
    
    void getPushOrders(IN const char* json,OUT std::vector<orderObj> &vecOrders);

    /* 功能:判断是否是初始化数据
     * 参数:[1]待判断数据
     * 返回:...
     * */
    bool isInitData(IN const std::string& data);
    /* 功能:检查初始化数据是否可用
     * 参数:[1]待检查数据[2]POS监听端口
     * 返回:是否正确格式
     * */
    bool checkInitData(IN const std::string& data, OUT int& posListenPort);

    /* 功能:获取POS请求的返回数据
     * 参数:[1]状态码[2]消息[3]转换后数据
     * 重载:[1]ODS返回数据[2]转换后数据
     * 返回:是否转换成功
     * */
    bool getPosResponseData(IN int status, IN const std::string& msg, OUT std::string& result);
    bool getPosResponseData(IN const std::string& odsResponse, OUT std::string& result);

    /* 功能:获取ODS推送的返回数据
     * 参数:[1]状态码[2]消息[3]转换后数据
     * 重载:[1]POS返回数据[2]订单数据[3]转换后数据
     * 返回:是否转换成功
     * */
    bool getOdsResponseData(IN int status_code, IN const std::string& msg, OUT std::string& result);
    bool getOdsResponseData(IN const std::string& posResponse, IN const std::string& orderData, OUT std::string& result);

    /* 功能:转换POS数据格式到中台数据格式
     * 参数:[1]POS数据格式[2]转换后数据
     * 返回:是否转换成功
     * */
    bool convertDataPos2Ods(IN const std::string& data, OUT std::string& result);

    /* 功能:转换中台数据格式到POS数据格式
     * 参数:[1]中台数据格式[2]转换后数据
     * 返回:是否转换成功
     * */
    bool convertDataOds2Pos(IN const std::string& data, OUT std::string& result);

    std::string convertToNewOrderJson(orderObj &obj);
    std::string convertToOrderStatusJson(orderStatusObj &obj);
    std::string convertToRefundJson(refundObj &obj);
    std::string convertToStockWarnJson(stockWarnObj &obj);

private:
    std::string _getDeliveryTypeString(int type);
    //订单状态转换（转换为POS对应的状态）
    int _getPOSOrderStatus(int status);
};

#endif
