#include "JsonModule.h"
#include "../3rdParty/rapidjson/rapidjson.h"
#include "../3rdParty/rapidjson/document.h"
#include "../3rdParty/rapidjson/reader.h"
#include "../3rdParty/rapidjson/writer.h"
#include "../3rdParty/rapidjson/stringbuffer.h"
#include "../3rdParty/easylogging/easylogging++.h"

using namespace rapidjson;

// std::string GetTestJson(const int statuscode,const char* msg,const char* orderid)
// {
//     rapidjson::StringBuffer buffer;
//     rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
//     writer.StartObject();

//     writer.Key("statusCode");
//     writer.Int(statuscode);

//     writer.Key("msg");
//     writer.String(msg);

//     writer.Key("orderid");
//     writer.String(orderid);   

//     writer.EndObject();

//     return buffer.GetString();
// }

// void parseJson(const char* json)
// {
//     rapidjson::Document document; // 定义一个Document对象
//     document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
//     if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
//     {
//         // 可通过GetParseError()取得出错代码，
//         // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
//         // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
//         // 函数GetErrorOffset()返回出错发生的位置
//         LOG(ERROR)<<"JSON parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
//     }
//     else
//     {
//         rapidjson::Value& vStatusCode = document["statusCode"];
//         rapidjson::Value& vMsg = document["msg"];
//         rapidjson::Value& vOrderid = document["orderid"];

//         int iStatusCode = vStatusCode.GetInt();
//         std::string strMsg = vMsg.GetString();
//         std::string strOrderid = vOrderid.GetString();
    
//         LOG(INFO)<<"statusCode:"<<iStatusCode;
//         LOG(INFO)<<"msg:"<<strMsg.data();
//         LOG(INFO)<<"orderId:"<<strOrderid.data();
//     }
// }

JsonModule::JsonModule()
{

}

JsonModule::~JsonModule()
{

}

void JsonModule::getPushOrders(IN const char* json,OUT std::vector<orderObj> &vecOrders)
{ 
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        // 可通过GetParseError()取得出错代码，
        // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
        // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
        // 函数GetErrorOffset()返回出错发生的位置
        LOG(ERROR)<<"JSON parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
    }
    else
    {
        rapidjson::Value& vCode = document["code"];
        rapidjson::Value& vMsg = document["message"];
        rapidjson::Value& result_obj = document["result"];

        std::string strCode = vCode.GetString();
        if(strCode.compare("100")!=0)
            return;
        std::string strMsg = vMsg.GetString();
        if(result_obj.IsObject()){
            rapidjson::Value& orders_array = result_obj["orders"];
            if(orders_array.IsArray()){
                for(unsigned int i=0;i<orders_array.Size();i++){
                    orderObj order;
                    rapidjson::Value& objValue = orders_array[i];

                    rapidjson::Value& channel = objValue["channel"];
                    order.channel=channel.GetString();

                    rapidjson::Value& order_id = objValue["order_id"];
                    order.order_id=order_id.GetString();

                    rapidjson::Value& create_time = objValue["create_time"];
                    order.create_time=create_time.GetString();

                    rapidjson::Value& delivery_time = objValue["delivery_time"];
                    order.delivery_time=delivery_time.GetString();

                    rapidjson::Value& status = objValue["status"];
                    order.status=_getPOSOrderStatus(status.GetInt());

                    rapidjson::Value& status_desc = objValue["status_desc"];
                    order.status_desc=status_desc.GetString();

                    rapidjson::Value& total_fee = objValue["total_fee"];
                    order.total_price=total_fee.GetInt();

                    rapidjson::Value& send_fee = objValue["send_fee"];
                    order.delivery_price=send_fee.GetInt();

                    rapidjson::Value& discount_fee = objValue["discount_fee"];
                    order.reduced_price=discount_fee.GetInt();

                    //配送
                    rapidjson::Value& delivery_type = objValue["delivery_type"];
                    order.deliveryInfo.type=_getDeliveryTypeString(delivery_type.GetInt());

                    rapidjson::Value& delivery_status = objValue["delivery_status"];
                    order.deliveryInfo.status=delivery_status.GetInt();

                    rapidjson::Value& courier_name = objValue["courier_name"];
                    order.deliveryInfo.driver_name=courier_name.GetString();

                    rapidjson::Value& courier_phone = objValue["courier_phone"];
                    order.deliveryInfo.driver_phone=courier_phone.GetString();

                    //顾客信息
                    rapidjson::Value& customer = objValue["customer"];
                    order.customerInfo.name=customer.GetString();

                    rapidjson::Value& phone = objValue["phone"];
                    order.customerInfo.phone=phone.GetString();

                    rapidjson::Value& address = objValue["address"];
                    order.customerInfo.address=address.GetString();

                    //商品列表
                    rapidjson::Value& products_array = objValue["products"];
                    if(products_array.IsArray()){
                        for(unsigned int j=0;j<products_array.Size();j++){
                            productAttr proAttr;
                            rapidjson::Value& objProductValue = products_array[j];

                            rapidjson::Value& name = objValue["name"];
                            proAttr.pro.name=name.GetString();

                            rapidjson::Value& pid = objValue["pid"];
                            proAttr.pro.sku=pid.GetString();

                            rapidjson::Value& price = objValue["price"];
                            proAttr.pro.price=price.GetInt();

                            rapidjson::Value& productAmount = objValue["productAmount"];
                            proAttr.pro.qty=atoi(productAmount.GetString());

                            order.vecProducts.push_back(proAttr);

                        }
                    }

                    vecOrders.push_back(order);
                }
            }
        }
    }
}

bool JsonModule::isInitData(const std::string &data)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        LOG(ERROR) << "JSON parse error:" << document.GetParseError() << ":" << document.GetErrorOffset();
        return false;
    }
    return document["fm_cmd"].GetInt() == 1000;
}

bool JsonModule::checkInitData(const std::string &data, int &posListenPort)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(data); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        LOG(ERROR) << "JSON parse error:" << document.GetParseError() << ":" << document.GetErrorOffset();
        return false;
    }

    if( document["store_id"].GetString().empty()
            || document["store_id"].GetString().empty()
            || document["pos_id"].GetString().empty()
            || document["operator_id"].GetString().empty()
            || !document.HasMember("is_master")
            || document["listen_port"].GetInt()< 0 )
    {
        return false;
    }

    posListenPort = document["listen_port"].GetInt();
    return true;
}

bool JsonModule::getPosResponseData(int status, const std::string &msg, std::string &result)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("status_code");
    writer.Int(status);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::getPosResponseData(const std::string &odsResponse, std::string &result)
{
    result = "{\"status_code\":100, \"msg\":\"\"}";
    return true;
}

bool JsonModule::getOdsResponseData(int status_code, const std::string &msg, std::string &result)
{
    /*
    {
        "type" : 2,
        "order_id" : "xxxxx",
        "status" : 1,
        "status_code" : 100,
        "msg" : "接收订单成功"
    }
    */
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("type");
    writer.Int(2);

    writer.Key("order_id");
    writer.String("");

    writer.Key("status");
    writer.Int(0);

    writer.Key("status_code");
    writer.Int(status_code);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::getOdsResponseData(const std::string &posResponse, const std::string &orderData, std::string &result)
{
    int status_code;
    std::string msg;

    std::string order_id;
    int status;

    if( posResponse.empty() || orderData.empty() )
        return false;

    rapidjson::Document document, document1;
    document.Parse(posResponse);
    document1.Parse(orderData);
    if (document.HasParseError() || document1.HasParseError())
    {
        return false;
    }

    if( !document.HasMember("status_code")
            || !document1.HasMember("order_id")
            || !document1.HasMember("status") )
    {
        return false;
    }

    status_code = document["status_code"].GetInt();
    msg = document["msg"].GetString();

    order_id = document1["order_id"].GetString();
    status = document1["status"].GetInt();

    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("type");
    writer.Int(2);

    writer.Key("order_id");
    writer.String(order_id.c_str());

    writer.Key("status");
    writer.Int(status);

    writer.Key("status_code");
    writer.Int(status_code);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::convertDataPos2Ods(const std::string &data, std::string &result)
{

}

bool JsonModule::convertDataOds2Pos(const std::string &data, std::string &result)
{
    rapidjson::Document data;
    document.Parse(posResponse);
    document1.Parse(orderData);
    if (document.HasParseError() || document1.HasParseError())
    {
        return false;
    }

    if( !document.HasMember("status_code")
            || !document1.HasMember("order_id")
            || !document1.HasMember("status") )
    {
        return false;
    }
}

std::string JsonModule::convertToNewOrderJson(orderObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(obj.fm_cmd);

    writer.Key("channel");
    writer.String(obj.channel.c_str());

    writer.Key("order_no");
    writer.Int(obj.order_no);   

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("create_time");
    writer.String(obj.create_time.c_str());

    writer.Key("delivery_time");
    writer.String(obj.delivery_time.c_str());

    writer.Key("status");
    writer.Int(obj.status);  

    writer.Key("status_desc");
    writer.String(obj.status_desc.c_str());

    writer.Key("total_price");
    writer.Int(obj.total_price);  

    writer.Key("delivery_price");
    writer.Int(obj.delivery_price);  

    writer.Key("reduced_price");
    writer.Int(obj.reduced_price);  

    writer.Key("pickup_code");
    writer.String(obj.pickup_code.c_str());

    writer.Key("pickup_point");
    writer.String(obj.pickup_point.c_str());

    //----------------门店信息----------------
    writer.Key("store");
    writer.StartObject();

    writer.Key("store_id");
    writer.String(obj.storeInfo.store_id.c_str());

    writer.Key("pos_id");
    writer.String(obj.storeInfo.pos_id.c_str());

    writer.Key("vem_id");
    writer.String(obj.storeInfo.vem_id.c_str());

    writer.Key("vem_shelf");
    writer.String(obj.storeInfo.vem_shelf.c_str());

    writer.EndObject();
    //----------------门店信息 结束-----------
    
    //----------------配送信息----------------
    writer.Key("delivery");
    writer.StartObject();

    writer.Key("type");
    writer.String(obj.deliveryInfo.type.c_str());

    writer.Key("status");
    writer.Int(obj.deliveryInfo.status);

    writer.Key("status_desc");
    writer.String(obj.deliveryInfo.status_desc.c_str());

    writer.Key("driver_name");
    writer.String(obj.deliveryInfo.driver_name.c_str());

    writer.Key("driver_phone");
    writer.String(obj.deliveryInfo.driver_phone.c_str());

    writer.EndObject();
    //----------------配送信息 结束-----------

    //----------------顾客信息----------------
    writer.Key("customer");
    writer.StartObject();

    writer.Key("name");
    writer.String(obj.customerInfo.name.c_str());

    writer.Key("phone");
    writer.String(obj.customerInfo.phone.c_str());

    writer.Key("address");
    writer.String(obj.customerInfo.address.c_str());

    writer.Key("account");
    writer.String(obj.customerInfo.account.c_str());

    writer.Key("account_type");
    writer.Int(obj.customerInfo.account_type);

    writer.Key("account_level");
    writer.String(obj.customerInfo.account_level.c_str());

    writer.EndObject();
    //----------------顾客信息 结束-----------
    
    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].pro.source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].pro.attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].pro.combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].pro.bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].pro.bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].pro.name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].pro.price);

        writer.Key("qty");
        writer.Int(obj.vecProducts[i].pro.qty);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].pro.sku.c_str());

        //-----------------start 商品规格------------------
        writer.Key("specs");
        writer.StartArray();
        for(unsigned int j=0;j<obj.vecProducts[i].vecSpec.size();j++) 
        {
            writer.StartObject();

            writer.Key("name");
            writer.String(obj.vecProducts[i].vecSpec[j].name.c_str());

            writer.Key("price");
            writer.Int(obj.vecProducts[i].vecSpec[j].price);

            writer.Key("qty");
            writer.Int(obj.vecProducts[i].vecSpec[j].qty);

            writer.Key("sku");
            writer.String(obj.vecProducts[i].vecSpec[j].sku.c_str());

            writer.EndObject();
        }
        writer.EndArray();
        //-----------------end 商品规格--------------------

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------
    
    //----------------付款明细----------------
    writer.Key("payment");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.payInfo.summary.c_str());

    //-----------------start 付款详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.payInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("amount");
        writer.Int(obj.payInfo.vecDetail[i].amount);

        writer.Key("type");
        writer.Int(obj.payInfo.vecDetail[i].type);

        writer.Key("trans_id");
        writer.String(obj.payInfo.vecDetail[i].trans_id.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 付款详情--------------------    

    writer.EndObject();
    //----------------付款明细 结束-----------

    //----------------消费积分----------------
    writer.Key("bonus");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.bonusInfo.summary.c_str());

    //-----------------start 积分详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.bonusInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("type");
        writer.Int(obj.bonusInfo.vecDetail[i].type);

        writer.Key("desc");
        writer.String(obj.bonusInfo.vecDetail[i].desc.c_str());

        writer.Key("point");
        writer.Int(obj.bonusInfo.vecDetail[i].point);

        writer.Key("sku");
        writer.String(obj.bonusInfo.vecDetail[i].sku.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 积分详情--------------------    

    writer.EndObject();
    //----------------消费积分 结束-----------
    
    //----------------促销列表----------------
    writer.Key("promotions");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.promotionInfo.summary.c_str());

    //-----------------start 促销详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.promotionInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("type");
        writer.Int(obj.promotionInfo.vecDetail[i].type);

        writer.Key("desc");
        writer.String(obj.promotionInfo.vecDetail[i].desc.c_str());

        writer.Key("offer");
        writer.Int(obj.promotionInfo.vecDetail[i].offer);

        writer.Key("sku");
        writer.String(obj.promotionInfo.vecDetail[i].sku.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 促销详情--------------------    

    writer.EndObject();
    //----------------促销列表 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::convertToOrderStatusJson(orderStatusObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(obj.fm_cmd);

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("order_status");
    writer.Int(obj.order_status);

    writer.Key("delivery_status");
    writer.Int(obj.delivery_status);

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::convertToRefundJson(refundObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(obj.fm_cmd);

    writer.Key("channel");
    writer.String(obj.channel.c_str());

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("refund_amount");
    writer.Int(obj.refund_amount);

    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].pro.source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].pro.attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].pro.combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].pro.bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].pro.bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].pro.name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].pro.price);

        writer.Key("qty");
        writer.Int(obj.vecProducts[i].pro.qty);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].pro.sku.c_str());

        //-----------------start 商品规格------------------
        writer.Key("specs");
        writer.StartArray();
        for(unsigned int j=0;j<obj.vecProducts[i].vecSpec.size();j++) 
        {
            writer.StartObject();

            writer.Key("name");
            writer.String(obj.vecProducts[i].vecSpec[j].name.c_str());

            writer.Key("price");
            writer.Int(obj.vecProducts[i].vecSpec[j].price);

            writer.Key("qty");
            writer.Int(obj.vecProducts[i].vecSpec[j].qty);

            writer.Key("sku");
            writer.String(obj.vecProducts[i].vecSpec[j].sku.c_str());

            writer.EndObject();
        }
        writer.EndArray();
        //-----------------end 商品规格--------------------

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::convertToStockWarnJson(stockWarnObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(obj.fm_cmd);

    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].price);

        writer.Key("stock");
        writer.Int(obj.vecProducts[i].stock);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].sku.c_str());

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::_getDeliveryTypeString(int type)
{
    std::string rlt;
    switch(type)
    {
        case ODS_DELIVERY_TYPE_SELF:
            rlt=DELIVERY_TYPE_SELF;
            break;
        case ODS_DELIVERY_TYPE_PLATFORM:
            rlt=DELIVERY_TYPE_PLATFORM;
            break;
        default:
            break;
    }
    return rlt;
}

int JsonModule::_getPOSOrderStatus(int status)
{
    int rltStatus=0;
    switch(status)
    {
        case ODS_ORDERSTATUS_NEW:
            rltStatus=ORDERSTATUS_NEW;
            break;
        case ODS_ORDERSTATUS_CONFIRMED:
            rltStatus=ORDERSTATUS_CONFIRMED;
            break;    
        case ODS_ORDERSTATUS_CANCELED:
            rltStatus=ORDERSTATUS_CANCELED;
            break; 
        case ODS_ORDERSTATUS_SHIPPING:
            rltStatus=ORDERSTATUS_SHIPPING;
            break; 
        case ODS_ORDERSTATUS_WAIT_SHIPPING:
            rltStatus=ORDERSTATUS_CONFIRMED;
            break; 
        case ODS_ORDERSTATUS_COMPLETE:
            rltStatus=ORDERSTATUS_COMPLETE;
            break; 
        case ODS_ORDERSTATUS_DONE:
            rltStatus=ORDERSTATUS_COMPLETE;
            break; 
        case ODS_ORDERSTATUS_REFUND_FULL:
            rltStatus=ORDERSTATUS_REFUND_FULL;
            break; 
        case ODS_ORDERSTATUS_REFUND_PART:
            rltStatus=ORDERSTATUS_REFUND_PART;
            break; 
        case ODS_ORDERSTATUS_REFUND_COMPLETE:
            rltStatus=ORDERSTATUS_REFUND_COMPLETE;
            break;                                         
        default:
            break;
    }
    return rltStatus;
}
