#include <iostream>
#include <fstream>
#include <pthread.h>
#include "JsonModule.h"
#include "SocketModule.h"
#include "../utility/utility.h"
#include "../utility/zini.h"
#include "SQLiteModule.h"

#define ELPP_NO_DEFAULT_LOG_FILE
#include "../3rdParty/easylogging/easylogging++.h"

INITIALIZE_EASYLOGGINGPP

std::string g_init_data;

std::string ods_ip;
std::string pos_ip = "127.0.0.1";
int ods_push_port;
int ods_recv_port;
int client_listen_port;
int pos_listen_port;

void logRolloutHandler(const char* filename, std::size_t size)
{
    /// 备份日志
    //std::string strLogPath = GetProcDir();
    //strLogPath.append(filename);

    std::stringstream ss;
    ss << "mv " << filename << " "<<filename<<"_bk";
    LOG(INFO)<<"备份日志："<<ss.str().c_str();
    system(ss.str().c_str());
}

void* listen_pos_func(void* arg)  
{
    TCPServer server;
    JsonModule jsonTool;

    if( server.doListen(client_listen_port) )
    {
        LOG(INFO) << "local listen port: [" << client_listen_port << "] successful";
    }else
    {
        LOG(INFO) << "local listen port: [" << client_listen_port << "] failed";
    }

    while(true)
    {
        TCPClient pos;

        std::string posRequestData;
        std::string requestOdsData;
        std::string responseData;

        if( server.accept(pos) )
        {
            char tmpBuf[BUF_SIZE] = {0};
            if( pos.read(tmpBuf, sizeof(tmpBuf)) )
            {
                posRequestData = tmpBuf;
                // 如果为初始化请求则通过长连接socket发送
                if( jsonTool.isInitData(posRequestData) )
                {
                    if( jsonTool.checkInitData(posRequestData, pos_listen_port) )
                    {
                        g_init_data = posRequestData;
                        jsonTool.getPosResponseData(100, "successful!", responseData);
                        LOG(INFO) <<"POS init data:"<<g_init_data.c_str();
                    }else
                    {
                        jsonTool.getPosResponseData(101, "invalid initdata!", responseData);
                    }
                }else
                {
                    // 将POS请求数据转换为中台可接受数据格式
                    if( jsonTool.convertDataPos2Ods(posRequestData, requestOdsData) )
                    {
                        // 同步阻塞发送到ODS并等待返回
                        TCPClient ods;
                        if( ods.doConnect(ods_recv_port, ods_ip.c_str()) )
                        {
                            if( ods.send(requestOdsData) )
                            {
                                std::string tmp;
                                if( ods.receive(tmp) )
                                {
                                    jsonTool.getPosResponseData(tmp, responseData);
                                }else
                                {
                                    jsonTool.getPosResponseData(101, "receive data from [ODS] failed!", responseData);
                                }
                            }else
                            {
                                jsonTool.getPosResponseData(101, "send data to [ODS] failed!", responseData);
                            }

                            ods.close();
                        }else
                        {
                            jsonTool.getPosResponseData(101, "connect [ODS] failed!", responseData);
                        }
                    }else
                    {
                        jsonTool.getPosResponseData(101, "convert data to [ODS] format failed!", responseData);
                    }
                }

                // TODO待加入重试机制
                pos.write(responseData.c_str());
                pos.close();
            }else
            {
                LOG(INFO) << "recv pos pushDate failed";
            }
        }else
        {
            LOG(INFO) << "accept pos connect failed";
        }
    }
}


int main()
{   
    /* Mark
     * 与ODS通信全部加数据头(长度)
     * 与POS通信全部不加数据头
     * end*/

    signal(SIGPIPE, SIG_IGN);
    
    // 初始化日志
    el::Loggers::addFlag(el::LoggingFlag::StrictLogFileSizeCheck);
    std::string strBinPath = GetProcDir();
    std::string strLogPath(strBinPath.data());
    strLogPath.append("log.conf");
    el::Configurations conf(strLogPath.data());
    /// 设置全部logger的配置
    el::Loggers::reconfigureAllLoggers(conf);
    /// 注册回调函数
    el::Helpers::installPreRollOutCallback(logRolloutHandler);

    LOG(INFO)<<"---------software start---------";

    // 读取配置文件信息
    std::string strIniPath(strBinPath.data());
    strIniPath.append("config.ini");

    ods_ip = ZIni::readString("ODS","ip", "", strIniPath.c_str());
    ods_push_port = ZIni::readInt("ODS", "pushPort", 0, strIniPath.c_str());
    ods_recv_port = ZIni::readInt("ODS", "recvPort", 0, strIniPath.c_str());

    pos_ip = ZIni::readString("POS","ip", "", strIniPath.c_str());
    pos_listen_port = ZIni::readInt("POS","port", 0, strIniPath.c_str());

    client_listen_port = ZIni::readInt("SYS", "port", 0, strIniPath.c_str());

    LOG(INFO) << "[ODS]ip: " << ods_ip.data()
              << "-push port: " << ods_push_port
              << "-recv port: " << ods_recv_port;
    LOG(INFO) << "[POS]ip: " << pos_ip
              << "-listen port: " << pos_listen_port;
    LOG(INFO) << "[Local]listen port: " << client_listen_port;
    //end
    
    // 监听POS请求的线程
    pthread_t listen_pos_id;

    /*创建 listen_pos 线程*/
    if(pthread_create(&listen_pos_id,NULL,listen_pos_func,NULL))
        LOG(INFO) << "create listen_pos thread failed";

    TCPClient ods;
    JsonModule jsonTool;

    while(true)
    {
        std::string odsPushData;
        std::string pushPosData;
        std::string responseData;

        // 判断是否成功连接ODS
        if( !ods.isValid() )
        {
            if( ods.doConnect(ods_push_port, ods_ip.c_str()) )
            {
                LOG(INFO) << "connect ODS successful";

                // 注册socket信息
                while(true)
                {
                    g_init_data = "{\"fm_cmd\": 1000,\"store_id\": \"208888\",\"pos_id\": \"0001\",\"operator_id\": \"00001\",\"business_date\": \"20171225\",\"is_master\": true,\"listen_port\": 3289}";

                    if(!g_init_data.empty())
                    {
                        if( ods.send(g_init_data) )
                        {
                            ods.receive(odsPushData);
                            break;
                        }
                    }
                    sleep(1);
                    continue;
                }
            }else
            {
                LOG(INFO) << "connect ODS failed";
                sleep(2);
                continue;
            }
        }

        if( ods.receive(odsPushData) )
        {
            LOG(INFO) << "----------------recved ODS data------------------";
            LOG(INFO) << odsPushData;
            if( jsonTool.convertDataOds2Pos(odsPushData, pushPosData) )
            {
                LOG(INFO) << "********convert data to pos************";
                LOG(INFO) << pushPosData;
                TCPClient pos;
                if( pos.doConnect(pos_listen_port, pos_ip.c_str()) )
                {
                    if( pos.write(pushPosData.c_str()) )
                    {
                        char tmpBuf[BUF_SIZE] = {0};
                        if( pos.read(tmpBuf,sizeof(tmpBuf)) )
                        {
                            std::string tmp(tmpBuf);
                            jsonTool.getOdsResponseData(tmp, odsPushData, responseData);
                        }else
                        {
                            jsonTool.getOdsResponseData(101, "receive data from [POS] failed!", responseData);
                        }
                    }else
                    {
                        jsonTool.getOdsResponseData(101, "send data to [POS] failed!", responseData);
                    }

                    pos.close();
                }else
                {
                    jsonTool.getOdsResponseData(101, "connect [POS] failed!", responseData);
                }
            }else
            {
                jsonTool.getOdsResponseData(101, "convert data to [POS] format failed!", responseData);
            }

            // TODO待加入重试机制
            ods.send(responseData);
        }else
        {
            LOG(INFO) << "recv ODS pushDate failed";
        }
    }

    return 0;
}

