#ifndef SQLITE_MODULE_H
#define SQLITE_MODULE_H
#include <iostream>
#include <sqlite3.h>

class SQLite
{
public:
    SQLite();
    ~SQLite();

    bool initSQLite();
    void closeSQLite();

    int isRecordExist(std::string strTable,std::string strKey);
    bool isTableExist(sqlite3 *sqDb, std::string strTableName);
    bool insert(const char* sql);
    bool update(const char* sql);
    bool remove(const char* sql);
    void query(const char* sql);
private:
    bool _execSql(const char* sql);
    bool _createTable();
private:
    
    sqlite3 *pDB;
    char * errMsg;
};

#endif

