#include "JsonModule.h"
#include "../3rdParty/rapidjson/rapidjson.h"
#include "../3rdParty/rapidjson/document.h"
#include "../3rdParty/rapidjson/reader.h"
#include "../3rdParty/rapidjson/writer.h"
#include "../3rdParty/rapidjson/stringbuffer.h"
#include "../3rdParty/easylogging/easylogging++.h"

#include <iostream>

using namespace rapidjson;

// std::string GetTestJson(const int statuscode,const char* msg,const char* orderid)
// {
//     rapidjson::StringBuffer buffer;
//     rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
//     writer.StartObject();

//     writer.Key("statusCode");
//     writer.Int(statuscode);

//     writer.Key("msg");
//     writer.String(msg);

//     writer.Key("orderid");
//     writer.String(orderid);   

//     writer.EndObject();

//     return buffer.GetString();
// }

// void parseJson(const char* json)
// {
//     rapidjson::Document document; // 定义一个Document对象
//     document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
//     if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
//     {
//         // 可通过GetParseError()取得出错代码，
//         // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
//         // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
//         // 函数GetErrorOffset()返回出错发生的位置
//         LOG(ERROR)<<"JSON parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
//     }
//     else
//     {
//         rapidjson::Value& vStatusCode = document["statusCode"];
//         rapidjson::Value& vMsg = document["msg"];
//         rapidjson::Value& vOrderid = document["orderid"];

//         int iStatusCode = vStatusCode.GetInt();
//         std::string strMsg = vMsg.GetString();
//         std::string strOrderid = vOrderid.GetString();
    
//         LOG(INFO)<<"statusCode:"<<iStatusCode;
//         LOG(INFO)<<"msg:"<<strMsg;
//         LOG(INFO)<<"orderId:"<<strOrderid;
//     }
// }

JsonModule::JsonModule()
{

}

JsonModule::~JsonModule()
{

}

bool JsonModule::getPushOrders(IN const char* json,OUT orderObj &order)
{ 
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        // 可通过GetParseError()取得出错代码，
        // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
        // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
        // 函数GetErrorOffset()返回出错发生的位置
        LOG(ERROR)<<"JSON parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
        return false;
    }
    else
    {
        rapidjson::Value& channel = document["channel"];
        order.channel=channel.GetString();

        rapidjson::Value& token = document["token"];
        token.GetString();

        rapidjson::Value& ver = document["ver"];
        ver.GetInt();

        //配送信息
        {
            
            rapidjson::Value& delivery_obj = document["delivery"];
			if(delivery_obj.IsObject())
			{
				if(delivery_obj.HasMember("customerAddress"))
				{
					rapidjson::Value& customerAddress = delivery_obj["customerAddress"];
					order.customerInfo.address=customerAddress.GetString();
				}
				if(delivery_obj.HasMember("customerName"))
				{
					rapidjson::Value& customerName = delivery_obj["customerName"];
					order.customerInfo.name = customerName.GetString();
				}
				if(delivery_obj.HasMember("customerPhone"))
				{
					rapidjson::Value& customerPhone = delivery_obj["customerPhone"];
					order.customerInfo.phone = customerPhone.GetString();
				}
				if(delivery_obj.HasMember("deliveryTime"))
				{
					rapidjson::Value& deliveryTime = delivery_obj["deliveryTime"];
					order.delivery_time = deliveryTime.GetString();
				}
				if(delivery_obj.HasMember("name"))
				{
					rapidjson::Value& name = delivery_obj["name"];
					order.deliveryInfo.driver_name = name.GetString();
				}
				if(delivery_obj.HasMember("phone"))
				{
					rapidjson::Value& phone = delivery_obj["phone"];
					order.deliveryInfo.driver_phone = phone.GetString();
				}
				if(delivery_obj.HasMember("type"))
				{
					rapidjson::Value& type = delivery_obj["type"];
					order.deliveryInfo.type = type.GetString();
				}
			}
			
        }
        //发票信息
        {
            rapidjson::Value& invoice_obj = document["invoice"];
			if(invoice_obj.IsObject())
			{
				if(invoice_obj.HasMember("companyName"))
				{
					rapidjson::Value& companyName = invoice_obj["companyName"];
					companyName.GetString();
				}
				if(invoice_obj.HasMember("invoiceType"))
				{
					rapidjson::Value& invoiceType = invoice_obj["invoiceType"];
					invoiceType.GetInt();
				}
				if(invoice_obj.HasMember("taxNum"))
				{
					rapidjson::Value& taxNum = invoice_obj["taxNum"];
					taxNum.GetString();
				}
				if(invoice_obj.HasMember("title"))
				{
					rapidjson::Value& title = invoice_obj["title"];
					title.GetString();
				}
				if(invoice_obj.HasMember("transNum"))
				{
					rapidjson::Value& transNum = invoice_obj["transNum"];
					transNum.GetString();
				}
			}
			
        }
        //订单内容
        {
            rapidjson::Value& orderContent_obj = document["orderContent"];
        
            rapidjson::Value& createTime = orderContent_obj["createTime"];
            order.create_time = createTime.GetString();

            //用户信息
            //TODO 顾客信息为数组 因接口改版目前只有一个顾客信息
            rapidjson::Value& customer_array = orderContent_obj["customer"];
            if(customer_array.IsArray())
            {
                for(unsigned int i=0;i<customer_array.Size();i++){
                    rapidjson::Value& customer_obj = customer_array[i];

                    rapidjson::Value& accountId = customer_obj["accountId"];
                    order.customerInfo.account = accountId.GetString();

                    rapidjson::Value& accountType= customer_obj["accountType"];
                    order.customerInfo.account_type = atoi(accountType.GetString());

                    rapidjson::Value& level = customer_obj["level"];
                    order.customerInfo.account_level = level.GetString();

                }
            }

            rapidjson::Value& deliveryFee = orderContent_obj["deliveryFee"];
            order.delivery_price = deliveryFee.GetInt();

            //订单信息
            {
                rapidjson::Value& orders_obj = orderContent_obj["orders"];

                rapidjson::Value& deliveryStatus = orders_obj["deliveryStatus"];
                order.deliveryInfo.status = atoi(deliveryStatus.GetString());

                rapidjson::Value& deliveryStatusDesc = orders_obj["deliveryStatusDesc"];
                order.deliveryInfo.status_desc = deliveryStatusDesc.GetString();     

                rapidjson::Value& orderId = orders_obj["orderId"];
                order.order_id = orderId.GetString();  
                rapidjson::Value& pickupCode = orders_obj["pickupCode"];
                order.pickup_code= pickupCode.GetString();  
                rapidjson::Value& pickupPoint = orders_obj["pickupPoint"];
                order.pickup_point = pickupPoint.GetString();  
                rapidjson::Value& remark = orders_obj["remark"];
                remark.GetString();  
                rapidjson::Value& status = orders_obj["status"];
                order.status = atoi(status.GetString());  
                rapidjson::Value& statusDesc = orders_obj["statusDesc"];
                order.status_desc = statusDesc.GetString();  

                //订单商品 
                {
                    rapidjson::Value& products_array = orders_obj["products"];
                    if(products_array.IsArray())
                    {
                        for(unsigned int i=0;i<products_array.Size();i++){
                            rapidjson::Value& product_obj = products_array[i];

                            productAttr structProduct;

                            rapidjson::Value& attributes = product_obj["attributes"];
                            structProduct.pro.attributes = attributes.GetString();

                            rapidjson::Value& catgId= product_obj["catgId"];
                            structProduct.pro.combo_id = catgId.GetString();

                            rapidjson::Value& groupIndex = product_obj["groupIndex"];
                            structProduct.pro.bom_id = groupIndex.GetString();

                            rapidjson::Value& name = product_obj["name"];
                            structProduct.pro.name = name.GetString();

                            rapidjson::Value& price= product_obj["price"];
                            structProduct.pro.price = price.GetInt();

                            rapidjson::Value& productType = product_obj["productType"];
                            productType.GetString();

                            rapidjson::Value& qty = product_obj["qty"];
                            structProduct.pro.qty = qty.GetInt();

                            rapidjson::Value& sku= product_obj["sku"];
                            structProduct.pro.sku = sku.GetString();

                            rapidjson::Value& source = product_obj["source"];
                            structProduct.pro.source = source.GetString();

                            //子商品信息
                            {
                                rapidjson::Value& specs_array = product_obj["specs"];
                                if(specs_array.IsArray())
                                {
                                    for(unsigned int i=0;i<specs_array.Size();i++){
                                        rapidjson::Value& specs_obj = specs_array[i];

                                        productSpec structProductSpec;

                                        rapidjson::Value& name = specs_obj["name"];
                                        structProductSpec.name = name.GetString();

                                        rapidjson::Value& price= specs_obj["price"];
                                        structProductSpec.price = price.GetInt();

                                        rapidjson::Value& qty = specs_obj["qty"];
                                        structProductSpec.qty = qty.GetInt();

                                        rapidjson::Value& sku = specs_obj["sku"];
                                        structProductSpec.sku = sku.GetString();
                                        structProduct.vecSpec.push_back(structProductSpec);
                                    }
                                }
                            }
                            order.vecProducts.push_back(structProduct);
                        }
                    }
                }
            }
            //支付信息
            {
                //TODO
                //sumary未映射字段值
                rapidjson::Value& payInfos_array = orderContent_obj["payInfos"];
                if(payInfos_array.IsArray())
                {
                    for(unsigned int i=0;i<payInfos_array.Size();i++){
                        rapidjson::Value& payInfos_obj = payInfos_array[i];
                        paymentDetail detail;

                        rapidjson::Value& amount= payInfos_obj["amount"];
                        detail.amount = amount.GetInt();

                        rapidjson::Value& payType = payInfos_obj["payType"];
                        detail.type = atoi(payType.GetString());

                        rapidjson::Value& transNum = payInfos_obj["transNum"];
                        detail.trans_id = transNum.GetString();
                        order.payInfo.vecDetail.push_back(detail);
                    }
                }
            }
            rapidjson::Value& payType = orderContent_obj["payType"];
            payType.GetString();
            //积分信息
            {
                rapidjson::Value& points_obj = orderContent_obj["points"];
                rapidjson::Value& totalPoint= points_obj["totalPoint"];
                order.bonusInfo.summary = std::to_string(totalPoint.GetInt());

                //积分信息详情
                {
                    rapidjson::Value& pointDetails_array = points_obj["pointDetails"];
                    if(pointDetails_array.IsArray())
                    {
                        for(unsigned int i=0;i<pointDetails_array.Size();i++){
                            rapidjson::Value& pointDetails_obj = pointDetails_array[i];

                            bonusDetail detail;
                            rapidjson::Value& bomId= pointDetails_obj["bomId"];
                            bomId.GetString();

                            rapidjson::Value& comboId = pointDetails_obj["comboId"];
                            comboId.GetString();

                            rapidjson::Value& desc = pointDetails_obj["desc"];
                            detail.desc = desc.GetString();

                            rapidjson::Value& groupId = pointDetails_obj["groupId"];
                            groupId.GetString();

                            rapidjson::Value& point = pointDetails_obj["point"];
                            detail.point = point.GetInt();

                            rapidjson::Value& sku = pointDetails_obj["sku"];
                            detail.sku = sku.GetString();

                            rapidjson::Value& type = pointDetails_obj["type"];
                            detail.type = atoi(type.GetString());

                            order.bonusInfo.vecDetail.push_back(detail);
                        }
                    }
                }
            }
            //优惠信息
            {
                rapidjson::Value& promotions_obj = orderContent_obj["promotions"];
                rapidjson::Value& totalDiscount= promotions_obj["totalDiscount"];
                totalDiscount.GetInt();
                rapidjson::Value& totalOriginalPrice= promotions_obj["totalOriginalPrice"];
                totalOriginalPrice.GetInt();
                rapidjson::Value& totalPrmotionPrice= promotions_obj["totalPrmotionPrice"];
                totalPrmotionPrice.GetInt();

                //优惠信息详情
                {
                    rapidjson::Value& promtionDetails_array = promotions_obj["promtionDetails"];
                    if(promtionDetails_array.IsArray())
                    {
                        for(unsigned int i=0;i<promtionDetails_array.Size();i++){
                            rapidjson::Value& promtionDetails_obj = promtionDetails_array[i];

                            rapidjson::Value& bomId= promtionDetails_obj["bomId"];
                            bomId.GetString();

                            rapidjson::Value& comboId = promtionDetails_obj["comboId"];
                            comboId.GetString();

                            rapidjson::Value& desc = promtionDetails_obj["desc"];
                            desc.GetString();

                            rapidjson::Value& discount = promtionDetails_obj["discount"];
                            discount.GetInt();

                            rapidjson::Value& groupId = promtionDetails_obj["groupId"];
                            groupId.GetString();

                            rapidjson::Value& originalPrice = promtionDetails_obj["originalPrice"];
                            originalPrice.GetInt();

                            rapidjson::Value& pcode = promtionDetails_obj["pcode"];
                            pcode.GetString();

                            rapidjson::Value& prmotionPrice = promtionDetails_obj["prmotionPrice"];
                            prmotionPrice.GetInt();

                            rapidjson::Value& sku = promtionDetails_obj["sku"];
                            sku.GetString();

                            rapidjson::Value& type = promtionDetails_obj["type"];
                            type.GetString();
                        }
                    }
                }
            }
            rapidjson::Value& sessionId = orderContent_obj["sessionId"];
            sessionId.GetString();

            rapidjson::Value& totalAmount = orderContent_obj["totalAmount"];
            order.total_price = totalAmount.GetInt();

            rapidjson::Value& totalDiscount = orderContent_obj["totalDiscount"];
            order.reduced_price = totalDiscount.GetInt();

        }
        //第三方商户信息
        {
            rapidjson::Value& sellerInfo_obj = document["sellerInfo"];
			if(sellerInfo_obj.IsObject())
			{
				if(sellerInfo_obj.HasMember("sellerId"))
				{
					rapidjson::Value& sellerId = sellerInfo_obj["sellerId"];
					sellerId.GetString();
				}
				if(sellerInfo_obj.HasMember("sellerName"))
				{
					rapidjson::Value& sellerName = sellerInfo_obj["sellerName"];
					sellerName.GetString();
				}
			}
			
        }
        //门店信息
        {
            rapidjson::Value& shopInfo_obj = document["shopInfo"];
            
            rapidjson::Value& barCounter = shopInfo_obj["barCounter"];
            barCounter.GetString();

            rapidjson::Value& vOperator = shopInfo_obj["operator"];
            vOperator.GetString();

            rapidjson::Value& posId = shopInfo_obj["posId"];
            order.storeInfo.pos_id = posId.GetString();

            rapidjson::Value& storeId = shopInfo_obj["storeId"];
            order.storeInfo.store_id = storeId.GetString();

            //自助机信息
            rapidjson::Value& selfHelpMac_obj = shopInfo_obj["selfHelpMac"];

            rapidjson::Value& id = selfHelpMac_obj["id"];
            order.storeInfo.vem_id = id.GetString();

            rapidjson::Value& shelf = selfHelpMac_obj["shelf"];
            order.storeInfo.vem_shelf = shelf.GetString();
        }

    }
    return true;
}

bool JsonModule::isInitData(const std::string &data)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(data.c_str()); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        LOG(ERROR) << "JSON parse error:" << document.GetParseError() << ":" << document.GetErrorOffset();
        return false;
    }
    return document["fm_cmd"].GetInt() == 1000;
}

bool JsonModule::checkInitData(const std::string &data, int &posListenPort)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(data.c_str()); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        LOG(ERROR) << "JSON parse error:" << document.GetParseError() << ":" << document.GetErrorOffset();
        return false;
    }

    if( !document.HasMember("store_id")
            || !document.HasMember("pos_id")
            || !document.HasMember("operator_id")
            || !document.HasMember("is_master")
            || document["listen_port"].GetInt()< 0 )
    {
        return false;
    }

    posListenPort = document["listen_port"].GetInt();
    return true;
}

bool JsonModule::getPosResponseData(int status, const std::string &msg, std::string &result)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("status_code");
    writer.Int(status);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::getPosResponseData(const std::string &odsResponse, std::string &result)
{
    result = "{\"status_code\":100, \"msg\":\"\"}";
    return true;
}

bool JsonModule::getOdsResponseData(int status_code, const std::string &msg, std::string &result)
{
    /*
    {
        "fm_cmd" : 2,
        "order_id" : "xxxxx",
        "status" : 1,
        "status_code" : 100,
        "msg" : "接收订单成功"
    }
    */
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(2);

    writer.Key("order_id");
    writer.String("");

    writer.Key("status");
    writer.Int(0);

    writer.Key("status_code");
    writer.Int(status_code);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::getOdsResponseData(const std::string &posResponse, const std::string &orderData, std::string &result)
{
    int status_code;
    std::string msg;

    std::string order_id;
    int status;

    if( posResponse.empty() || orderData.empty() )
        return false;

    rapidjson::Document document, document1;
    document.Parse(posResponse.c_str());
    document1.Parse(orderData.c_str());
    if (document.HasParseError() || document1.HasParseError())
    {
        return false;
    }

    if( !document.HasMember("status_code")
            || !document1.HasMember("order_id")
            || !document1.HasMember("status") )
    {
        return false;
    }

    status_code = document["status_code"].GetInt();
    msg = document["msg"].GetString();

    order_id = document1["order_id"].GetString();
    status = document1["status"].GetInt();

    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(2);

    writer.Key("order_id");
    writer.String(order_id.c_str());

    writer.Key("status");
    writer.Int(status);

    writer.Key("status_code");
    writer.Int(status_code);

    writer.Key("msg");
    writer.String(msg.c_str());

    writer.EndObject();

    result = buffer.GetString();
    return true;
}

bool JsonModule::convertDataPos2Ods(const std::string &data, std::string &result)
{
    return true;
}

bool JsonModule::convertDataOds2Pos(const std::string &data, std::string &result)
{
    bool rlt=true;
    orderObj order;
    rlt = getPushOrders(data.c_str(),order);
	
	if(rlt)
	{
		result = _convertToNewOrderJson(order);
	}
	
    return rlt;
}

std::string JsonModule::_convertToNewOrderJson(orderObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(REQUEST_TYPE_NEWORDER_PUSH);

    writer.Key("channel");
    writer.String(obj.channel.c_str());

    writer.Key("order_no");
    writer.Int(obj.order_no);   

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("create_time");
    writer.String(obj.create_time.c_str());

    writer.Key("delivery_time");
    writer.String(obj.delivery_time.c_str());

    writer.Key("status");
    writer.Int(_getPOSOrderStatus(obj.status));  

    writer.Key("status_desc");
    writer.String(obj.status_desc.c_str());

    writer.Key("total_price");
    writer.Int(obj.total_price);  

    writer.Key("delivery_price");
    writer.Int(obj.delivery_price);  

    writer.Key("reduced_price");
    writer.Int(obj.reduced_price);  

    writer.Key("pickup_code");
    writer.String(obj.pickup_code.c_str());

    writer.Key("pickup_point");
    writer.String(obj.pickup_point.c_str());

    //----------------门店信息----------------
    writer.Key("store");
    writer.StartObject();

    writer.Key("store_id");
    writer.String(obj.storeInfo.store_id.c_str());

    writer.Key("pos_id");
    writer.String(obj.storeInfo.pos_id.c_str());

    writer.Key("vem_id");
    writer.String(obj.storeInfo.vem_id.c_str());

    writer.Key("vem_shelf");
    writer.String(obj.storeInfo.vem_shelf.c_str());

    writer.EndObject();
    //----------------门店信息 结束-----------
    
    //----------------配送信息----------------
    writer.Key("delivery");
    writer.StartObject();

    writer.Key("type");
    writer.String(obj.deliveryInfo.type.c_str());

    writer.Key("status");
    writer.Int(obj.deliveryInfo.status);

    writer.Key("status_desc");
    writer.String(obj.deliveryInfo.status_desc.c_str());

    writer.Key("driver_name");
    writer.String(obj.deliveryInfo.driver_name.c_str());

    writer.Key("driver_phone");
    writer.String(obj.deliveryInfo.driver_phone.c_str());

    writer.EndObject();
    //----------------配送信息 结束-----------

    //----------------顾客信息----------------
    writer.Key("customer");
    writer.StartObject();

    writer.Key("name");
    writer.String(obj.customerInfo.name.c_str());

    writer.Key("phone");
    writer.String(obj.customerInfo.phone.c_str());

    writer.Key("address");
    writer.String(obj.customerInfo.address.c_str());

    writer.Key("account");
    writer.String(obj.customerInfo.account.c_str());

    writer.Key("account_type");
    writer.Int(obj.customerInfo.account_type);

    writer.Key("account_level");
    writer.String(obj.customerInfo.account_level.c_str());

    writer.EndObject();
    //----------------顾客信息 结束-----------
    
    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].pro.source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].pro.attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].pro.combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].pro.bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].pro.bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].pro.name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].pro.price);

        writer.Key("qty");
        writer.Int(obj.vecProducts[i].pro.qty);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].pro.sku.c_str());

        //-----------------start 商品规格------------------
        writer.Key("specs");
        writer.StartArray();
        for(unsigned int j=0;j<obj.vecProducts[i].vecSpec.size();j++) 
        {
            writer.StartObject();

            writer.Key("name");
            writer.String(obj.vecProducts[i].vecSpec[j].name.c_str());

            writer.Key("price");
            writer.Int(obj.vecProducts[i].vecSpec[j].price);

            writer.Key("qty");
            writer.Int(obj.vecProducts[i].vecSpec[j].qty);

            writer.Key("sku");
            writer.String(obj.vecProducts[i].vecSpec[j].sku.c_str());

            writer.EndObject();
        }
        writer.EndArray();
        //-----------------end 商品规格--------------------

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------
    
    //----------------付款明细----------------
    writer.Key("payment");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.payInfo.summary.c_str());

    //-----------------start 付款详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.payInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("amount");
        writer.Int(obj.payInfo.vecDetail[i].amount);

        writer.Key("type");
        writer.Int(obj.payInfo.vecDetail[i].type);

        writer.Key("trans_id");
        writer.String(obj.payInfo.vecDetail[i].trans_id.c_str());
		
		writer.Key("account_id");
        writer.String(obj.payInfo.vecDetail[i].account_id.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 付款详情--------------------    

    writer.EndObject();
    //----------------付款明细 结束-----------

    //----------------消费积分----------------
    writer.Key("bonus");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.bonusInfo.summary.c_str());

    //-----------------start 积分详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.bonusInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("type");
        writer.Int(obj.bonusInfo.vecDetail[i].type);

        writer.Key("desc");
        writer.String(obj.bonusInfo.vecDetail[i].desc.c_str());

        writer.Key("point");
        writer.Int(obj.bonusInfo.vecDetail[i].point);

        writer.Key("sku");
        writer.String(obj.bonusInfo.vecDetail[i].sku.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 积分详情--------------------    

    writer.EndObject();
    //----------------消费积分 结束-----------
    
    //----------------促销列表----------------
    writer.Key("promotions");
    writer.StartObject();

    writer.Key("summary");
    writer.String(obj.promotionInfo.summary.c_str());

    //-----------------start 促销详情------------------
    writer.Key("details");
    writer.StartArray();
    for(unsigned int i=0;i<obj.promotionInfo.vecDetail.size();i++) 
    {
        writer.StartObject();

        writer.Key("type");
        writer.Int(obj.promotionInfo.vecDetail[i].type);

        writer.Key("desc");
        writer.String(obj.promotionInfo.vecDetail[i].desc.c_str());

        writer.Key("offer");
        writer.Int(obj.promotionInfo.vecDetail[i].offer);

        writer.Key("sku");
        writer.String(obj.promotionInfo.vecDetail[i].sku.c_str());

        writer.EndObject();
    }
    writer.EndArray();
    //-----------------end 促销详情--------------------    

    writer.EndObject();
    //----------------促销列表 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::_convertToOrderStatusJson(orderStatusObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(REQUEST_TYPE_STATUS_CHANGE);

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("order_status");
    writer.Int(_getPOSOrderStatus(obj.order_status));

    writer.Key("delivery_status");
    writer.Int(obj.delivery_status);

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::_convertToRefundJson(refundObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(REQUEST_TYPE_REFUND);

    writer.Key("channel");
    writer.String(obj.channel.c_str());

    writer.Key("order_id");
    writer.String(obj.order_id.c_str());

    writer.Key("refund_amount");
    writer.Int(obj.refund_amount);

    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].pro.source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].pro.attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].pro.combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].pro.bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].pro.bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].pro.name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].pro.price);

        writer.Key("qty");
        writer.Int(obj.vecProducts[i].pro.qty);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].pro.sku.c_str());

        //-----------------start 商品规格------------------
        writer.Key("specs");
        writer.StartArray();
        for(unsigned int j=0;j<obj.vecProducts[i].vecSpec.size();j++) 
        {
            writer.StartObject();

            writer.Key("name");
            writer.String(obj.vecProducts[i].vecSpec[j].name.c_str());

            writer.Key("price");
            writer.Int(obj.vecProducts[i].vecSpec[j].price);

            writer.Key("qty");
            writer.Int(obj.vecProducts[i].vecSpec[j].qty);

            writer.Key("sku");
            writer.String(obj.vecProducts[i].vecSpec[j].sku.c_str());

            writer.EndObject();
        }
        writer.EndArray();
        //-----------------end 商品规格--------------------

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::_convertToStockWarnJson(stockWarnObj &obj)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("fm_cmd");
    writer.Int(REQUEST_TYPE_STOCK_WARN);

    //----------------商品信息----------------
    writer.Key("products");
    writer.StartArray();

    for(unsigned int i=0;i<obj.vecProducts.size();i++) 
    {
        //-----------------start 单个商品------------------
        writer.StartObject();

        writer.Key("source");
        writer.String(obj.vecProducts[i].source.c_str());

        writer.Key("attributes");
        writer.String(obj.vecProducts[i].attributes.c_str());

        writer.Key("combo_id");
        writer.String(obj.vecProducts[i].combo_id.c_str());

        writer.Key("bom_id");
        writer.String(obj.vecProducts[i].bom_id.c_str());

        writer.Key("bag_id");
        writer.String(obj.vecProducts[i].bag_id.c_str());

        writer.Key("name");
        writer.String(obj.vecProducts[i].name.c_str());

        writer.Key("price");
        writer.Int(obj.vecProducts[i].price);

        writer.Key("stock");
        writer.Int(obj.vecProducts[i].stock);

        writer.Key("sku");
        writer.String(obj.vecProducts[i].sku.c_str());

        writer.EndObject();
        //-----------------end 单个商品------------------
    }
    
    writer.EndArray();
    //----------------商品信息 结束-----------

    writer.EndObject();

    return buffer.GetString();
}

std::string JsonModule::_getDeliveryTypeString(int type)
{
    std::string rlt;
    switch(type)
    {
        case ODS_DELIVERY_TYPE_SELF:
            rlt=DELIVERY_TYPE_SELF;
            break;
        case ODS_DELIVERY_TYPE_PLATFORM:
            rlt=DELIVERY_TYPE_PLATFORM;
            break;
        default:
            break;
    }
    return rlt;
}

int JsonModule::_getPOSOrderStatus(int status)
{
    int rltStatus=0;
    switch(status)
    {
        case ODS_ORDERSTATUS_NEW:
            rltStatus=ORDERSTATUS_NEW;
            break;
        case ODS_ORDERSTATUS_CONFIRMED:
            rltStatus=ORDERSTATUS_CONFIRMED;
            break;    
        case ODS_ORDERSTATUS_CANCELED:
            rltStatus=ORDERSTATUS_CANCELED;
            break; 
        case ODS_ORDERSTATUS_SHIPPING:
            rltStatus=ORDERSTATUS_SHIPPING;
            break; 
        case ODS_ORDERSTATUS_WAIT_SHIPPING:
            rltStatus=ORDERSTATUS_CONFIRMED;
            break; 
        case ODS_ORDERSTATUS_COMPLETE:
            rltStatus=ORDERSTATUS_COMPLETE;
            break; 
        case ODS_ORDERSTATUS_DONE:
            rltStatus=ORDERSTATUS_COMPLETE;
            break; 
        case ODS_ORDERSTATUS_REFUND_FULL:
            rltStatus=ORDERSTATUS_REFUND_FULL;
            break; 
        case ODS_ORDERSTATUS_REFUND_PART:
            rltStatus=ORDERSTATUS_REFUND_PART;
            break; 
        case ODS_ORDERSTATUS_REFUND_COMPLETE:
            rltStatus=ORDERSTATUS_REFUND_COMPLETE;
            break;                                         
        default:
            break;
    }
    return rltStatus;
}

void JsonModule::_getStatusObj(IN orderObj &order_obj,OUT orderStatusObj &status_obj)
{
    status_obj.order_id=order_obj.order_id;
    status_obj.order_status=order_obj.status;
    status_obj.delivery_status=order_obj.deliveryInfo.status;
}

void JsonModule::_getRefundObj(IN orderObj &order_obj,OUT refundObj &refund_obj)
{
    refund_obj.order_id=order_obj.order_id;
    refund_obj.channel=order_obj.channel;
    refund_obj.refund_amount=order_obj.total_price;
}
