#ifndef COMMON_STRUCT_H
#define COMMON_STRUCT_H

#include <iostream>
#include <vector>
//商品
struct product
{
    std::string source;                //商品来源
    std::string attributes;            //商品属性
    std::string combo_id;              //商品组合ID
    std::string bom_id;                //商品分组组合ID
    std::string bag_id;                //商品口袋ID
    std::string name;                  //商品名称
    int price=0;                       //商品价格
    int qty=0;                         //商品数量（商品使用）
    std::string sku;                   //商品SKU
    int stock=0;                       //商品当前库存（库存预警使用）
};

//商品规格
struct productSpec
{
    std::string name;                  //规格名称
    int price=0;                       //规格价格
    int qty=0;                         //规格数量
    std::string sku;                   //规格SKU
};  

//商品属性
struct productAttr
{
    product pro;                       //商品
    std::vector<productSpec> vecSpec;  //商品规格
};

//付款明细
struct paymentDetail
{
    int amount=0;                     //支付金额  
    int type=0;                       //支付类型
    std::string trans_id;             //支付交易号
};

//支付信息
struct payment
{
    std::string summary;                    //支付明细汇总 
    std::vector<paymentDetail> vecDetail;   //付款明细数组
};

//订单积分详情
struct bonusDetail
{
    int type=0;                       //积分类型
    std::string desc;                 //积分奖励描述
    int point=0;                      //积分奖励数值
    std::string sku;                  //积分商品
};

//订单积分
struct bonus
{
    std::string summary;                    //积分奖励总和 
    std::vector<bonusDetail> vecDetail;     //付款明细数组
};

//促销明细
struct promotionsDetail
{
    int type=0;                       //促销类型
    std::string desc;                 //促销描述
    int offer=0;                      //促销金额
    std::string sku;                  //促销商品
};

//促销
struct promotions
{
    std::string summary;                         //促销金额总和 
    std::vector<promotionsDetail> vecDetail;     //付款明细数组
};

//响应结果
struct responseRlt
{
    int status_code=0;                //响应状态码
    std::string msg;                  //响应提示信息
};

//门店信息
struct store
{
    std::string store_id;             //门店号
    std::string pos_id;               //订单推送 POS 编号
    std::string vem_id;               //自助终端编号
    std::string vem_shelf;            //自助终端货架号
};

//配送信息
struct delivery
{
    std::string type;                     //配送类型
    int status=0;                         //配送状态
    std::string status_desc;              //配送状态描述 
    std::string driver_name;              //外送骑手姓名 
    std::string driver_phone;             //骑手电话 
};

//顾客信息
struct customer
{                        
    std::string name;                     //顾客姓名 
    std::string phone;                    //顾客电话
    std::string address;                  //顾客地址
    std::string account;                  //顾客账号
    int account_type=0;                   //顾客账号类型
    std::string account_level;            //顾客账号等级 
};

//订单结构体
struct orderObj
{
    int fm_cmd=0;                                     //请求类型
    std::string channel;                              //订单渠道             
    int order_no=0;                                   //订单序号
    std::string order_id;                             //订单标识号
    std::string create_time;                          //订单创建时间
    std::string delivery_time;                        //订单期望送达时间
    int status=0;                                     //订单状态
    std::string status_desc;                          //订单状态描述
    int total_price=0;                                //订单总价
    int delivery_price=0;                             //配送费
    int reduced_price=0;                              //折扣总金额 
    std::string pickup_code;                          //自取订单取餐码
    std::string pickup_point;                         //自取订单取餐处 
    
    store storeInfo;                                  //门店信息 
    delivery deliveryInfo;                            //配送信息
    customer customerInfo;                            //顾客信息
    std::vector<productAttr> vecProducts;             //商品列表
    payment payInfo;                                  //付款明细
    bonus bonusInfo;                                  //消费积分
    promotions promotionInfo;                         //促销列表
};

//订单状态
struct orderStatusObj
{
    int fm_cmd=0;                      //请求类型 
    std::string order_id;              //订单编号
    int order_status=0;                //订单状态
    int delivery_status=0;             //配送状态
};

struct refundObj
{
    int fm_cmd=0;                            //请求类型(1003) 
    std::string channel;                     //订单渠道 
    std::string order_id;                    //订单编号 
    int refund_amount=0;                     //退款总金额 
    std::vector<productAttr> vecProducts;    //商品数组
};

struct stockWarnObj
{
    int fm_cmd=0;                            //请求类型(1006) 
    std::vector<product> vecProducts;        //商品数组
};

#endif