#ifndef BASE_DEFINE_H
#define BASE_DEFINE_H

#define IN
#define OUT

/***********************************
           POS相关预定义变量
 ***********************************/
//订单状态对照表
#define ORDERSTATUS_NEW                   1001          //新生成
#define ORDERSTATUS_CONFIRMED             1002          //已确定
#define ORDERSTATUS_CANCELED              1003          //已取消
#define ORDERSTATUS_SHIPPING              1004          //配送中
#define ORDERSTATUS_COMPLETE              1006          //已完成(已核销)
#define ORDERSTATUS_REFUND_FULL           1020          //申请全额退款
#define ORDERSTATUS_REFUND_PART           1021          //申请部分退款
#define ORDERSTATUS_REFUND_COMPLETE       1022          //退款完成

//请求类型对照表
#define REQUEST_TYPE_INIT                 1000          //初始化 
#define REQUEST_TYPE_NEWORDER_PUSH        1001          //新订单推送 
#define REQUEST_TYPE_STATUS_CHANGE        1002          //订单状态变更通知 
#define REQUEST_TYPE_REFUND               1003          //订单退款 
#define REQUEST_TYPE_GOODS_CHANGE         1004          //商品更换 
#define REQUEST_TYPE_POS_PRIORITY         1005          //设置POS优先级 
#define REQUEST_TYPE_STOCK_WARN           1006          //库存预警通知 

//配送类型对照表
#define DELIVERY_TYPE_SELF                "self"        //自配送 
#define DELIVERY_TYPE_PLATFORM            "platform"    //平台配送 
#define DELIVERY_TYPE_THRID               "thrid"       //第三方配送 

//配送状态对照表
#define DELIVERY_STATUS_WAIT              0             //等待配送 
#define DELIVERY_STATUS_CONFIRMED         1             //配送单已确认 
#define DELIVERY_STATUS_CANCELED          2             //配送单已取消 
#define DELIVERY_STATUS_SHIPPING          3             //配送中 
#define DELIVERY_STATUS_COMPLETE          4             //配送完成 

//平台代码对照表
#define PLANTFORM_CODE_OFFLINE_COMMON                       101     //线下普通单 
#define PLANTFORM_CODE_OFFLINE_YIGUO_DISTRIBUTION           102     //线下易果分销 
#define PLANTFORM_CODE_ONLINE_AUTO_MACHINE                  201     //线上自动贩卖机 
#define PLANTFORM_CODE_ONLINE_AUTO_WASHER                   202     //线上自动洗衣机 
#define PLANTFORM_CODE_ONLINE_QR_CODE                       203     //线上QR扫码购 
#define PLANTFORM_CODE_ONLINE_YIGUO_TO_QUANJIA_DISTRIBUTION 204     //线上易果给全家分销 
#define PLANTFORM_CODE_ONLINE_MEITUAN                       205     //线上美团外卖 
#define PLANTFORM_CODE_ONLINE_BAIDU                         206     //线上百度外卖 
#define PLANTFORM_CODE_ONLINE_ELEMA                         207     //线上饿了吗外卖 
#define PLANTFORM_CODE_ONLINE_JINGDONG                      208     //线上京东外卖 

//响应状态对照表
#define RESPONSE_CODE_SUCCESS              100           //成功 
#define RESPONSE_CODE_FAILED               101           //失败 


/***********************************
           ODS相关预定义变量
 ***********************************/
//配送类型对照表
#define ODS_DELIVERY_TYPE_SELF                0        //自配送 
#define ODS_DELIVERY_TYPE_PLATFORM            1        //平台配送 

//订单状态对照表
#define ODS_ORDERSTATUS_NEW                   1          //新生成
#define ODS_ORDERSTATUS_CONFIRMED             2          //已确定
#define ODS_ORDERSTATUS_CANCELED              3          //已取消
#define ODS_ORDERSTATUS_SHIPPING              4          //配送中
#define ODS_ORDERSTATUS_WAIT_SHIPPING         5          //等待配送
#define ODS_ORDERSTATUS_COMPLETE              6          //已送达
#define ODS_ORDERSTATUS_DONE                  200        //已送达
#define ODS_ORDERSTATUS_REFUND_FULL           20         //申请全额退款
#define ODS_ORDERSTATUS_REFUND_PART           21         //申请部分退款
#define ODS_ORDERSTATUS_REFUND_AGREE          30         //同意退款
#define ODS_ORDERSTATUS_REFUND_DISAGREE       40         //不同意退款
#define ODS_ORDERSTATUS_REFUND_COMPLETE       100        //退款完成

#endif