#include "IniDataManger.h"
#include "PreDefined.h"
#include "QsLog/QsLog.h"
#include <QFile>
#include <QDateTime>
#include <QApplication>
//#include "qjson/parser.h"
//#include "qjson/serializer.h"
#include <QStringList>
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>
#include <QJsonParseError>
#include <QTextCodec>
#include <QDebug>

IniDataManger &IniDataManger::Instance()
{
    static IniDataManger idm;
    return idm;
}

IniDataManger::StoreInfo IniDataManger::GetStoreInfo()
{
    StoreInfo storeInfo;
    storeInfo.business_date=m_set->value(INIPATH_STOREINFO_BUSINESSDATE).toString();
    storeInfo.mates_id=m_set->value(INIPATH_STOREINFO_MATESID).toString();
    storeInfo.operator_id=m_set->value(INIPATH_STOREINFO_OPERATOREID).toString();
    storeInfo.partner_id=m_set->value(INIPATH_STOREINFO_PARTNERID).toString();
    storeInfo.pos_id=m_set->value(INIPATH_STOREINFO_POSID).toString();
    storeInfo.store_id=m_set->value(INIPATH_STOREINFO_STOREID).toString();
    return storeInfo;
}

void IniDataManger::SetStoreInfo(IniDataManger::StoreInfo storeInfo)
{
//    m_set->setValue(INIPATH_STOREINFO_BUSINESSDATE,storeInfo.business_date);
//    m_set->setValue(INIPATH_STOREINFO_MATESID,storeInfo.mates_id);
//    m_set->setValue(INIPATH_STOREINFO_OPERATOREID,storeInfo.operator_id);
//    m_set->setValue(INIPATH_STOREINFO_PARTNERID,storeInfo.partner_id);
//    m_set->setValue(INIPATH_STOREINFO_POSID,storeInfo.pos_id);
//    m_set->setValue(INIPATH_STOREINFO_STOREID,storeInfo.store_id);
}

IniDataManger::LogInfo IniDataManger::GetLogInfo()
{
    LogInfo logInfo;
    logInfo.size = m_set->value(INIPATH_LOG_SIZE, DEFAULT_LOG_SIZE).toInt();
    logInfo.maxcount = m_set->value(INIPATH_LOG_MAXCOUNT, DEFAULT_LOG_MAXCOUNT).toInt();
    logInfo.level = m_set->value(INIPATH_LOG_LEVEL, DEFAULT_LOG_LEVEL).toInt();

    return logInfo;
}

IniDataManger::LoginInfo IniDataManger::GetLoginInfo()
{
    LoginInfo loginInfo;
    loginInfo.password = m_set->value(INIPATH_LOGIN_PASSWORD, DEFAULT_LOGIN_PASSWORD).toString();
    loginInfo.stationId = m_set->value(INIPATH_LOGIN_STATIONID, DEFAULT_LOGIN_STATIONID).toString();
    loginInfo.operatorId = m_set->value(INIPATH_LOGIN_OPERATORID, DEFAULT_LOGIN_OPERATORID).toString();

    return loginInfo;
}

QString IniDataManger::GetTheme()
{
    return m_userSet->value(INIPATH_APP_THEME, DEFAULT_APP_THEME).toString();
}

int IniDataManger::GetUdpPort()
{
    return m_set->value(INIPATH_UDP_PORT, DEFAULT_UDP_PORT).toInt();
}

IniDataManger::SqlServerInfo IniDataManger::GetSqlServerInfo()
{
    SqlServerInfo sqlInfo;
    sqlInfo.host = m_userSet->value(INIPATH_SQL_HOST, "").toString();
    sqlInfo.username = m_userSet->value(INIPATH_SQL_USERNAME, "").toString();
    sqlInfo.password = m_userSet->value(INIPATH_SQL_PASSWORD, "").toString();
    sqlInfo.database = m_userSet->value(INIPATH_SQL_DATABASE, "").toString();
    sqlInfo.timeout = m_userSet->value(INIPATH_SQL_TIMEOUT, DEFAULT_SQL_TIMEOUT).toInt();

    return sqlInfo;
}

QString IniDataManger::GetPrinterName()
{
    return m_fmps->value(INIPATH_PRINTER_NAME, "").toString();
}

IniDataManger::FmServerInfo IniDataManger::GetFmServerInfo()
{
    FmServerInfo fmsvInfo;
    fmsvInfo.bProxy = m_set->value(INIPATH_FMSERVER_PROXY, DEFAULT_FMSERVER_PROXY).toInt();
    fmsvInfo.url = m_set->value(INIPATH_FMSERVER_URL, "").toString();
    fmsvInfo.host = m_set->value(INIPATH_FMSERVER_HOST, "").toString();
    fmsvInfo.port = m_set->value(INIPATH_FMSERVER_PORT, "").toInt();

    return fmsvInfo;
}

bool IniDataManger::GetIsExistBtnComplete()
{
    return m_set->value(INIPATH_CUSTOM_BORDERCOMPLETE, DEFAULT_CUSTOM_BORDERCOMPLETE).toInt();
}

bool IniDataManger::GetIsExistOperator()
{
    return m_set->value(INIPATH_CUSTOM_OPERATOR, DEFAULT_CUSTOM_OPERATOR).toInt();
}

float IniDataManger::GetBlinkInterval()
{
    return m_userSet->value(INIPATH_FLOAT_BLINKINTERVAL, DEFAULT_FLOAT_BLINKINTERVAL).toFloat();
}

float IniDataManger::GetSoundInterval()
{
    return m_userSet->value(INIPATH_FLOAT_SOUNDINTERVAL, DEFAULT_FLOAT_SOUNDINTERVAL).toFloat();
}

QPoint IniDataManger::GetFloatPos()
{
    QPoint pos(FLOATFORM_POSX, FLOATFORM_POSY);

    QStringList pos_str = m_userSet->value(INIPATH_FLOAT_POS).toStringList();
    QString str_x = pos_str.first();
    QString str_y = pos_str.last();
    int x = str_x.toInt();
    int y = str_y.toInt();

    if(x > 0 && x < 1024 && y > 0 && y < 768) {
        pos.setX(x);
        pos.setY(y);
    }

    return pos;
}

QJsonObject IniDataManger::GetStoreJson()
{
   // return _GetFileJson(m_set->value(INIPATH_COMMFILE_STORE).toString());

    return m_storeJson;
}

QString IniDataManger::GetBillFile() const
{
    QString order_file = m_set->value(INIPATH_COMMFILE_BILL).toString();

    order_file = qApp->applicationDirPath() + "/" + order_file;

    return order_file;
}

QString IniDataManger::GetViviBillFile() const
{
    QString vivi_file = m_set->value(INIPATH_COMMFILE_VIVIBILL).toString();

    vivi_file = qApp->applicationDirPath() + "/" + vivi_file + "/";

    return vivi_file;
}


QString IniDataManger::GetTillFile()
{
    QString till_file = m_set->value(INIPATH_COMMFILE_TILL).toString();
    till_file = qApp->applicationDirPath() + "/" + till_file;

    return till_file;
}

bool IniDataManger::GetShowCancel()
{
    return m_set->value(INIPATH_SHOW_CANCEL).toBool();
}

QString IniDataManger::GetStoreIdPrefix()
{
    return m_set->value(INIPATH_STOREID_PREFIX).toString();
}

QString IniDataManger::GetChannelColor(const QString &channel)
{
    return m_set->value(INIPATH_CHANNEL_COLOR + channel).toString();
}

int IniDataManger::GetNotifyAcceptTimer() const
{
    return m_set->value(INIPATH_NOTIFY_ACCEPTTIMER).toInt();
}

QStringList IniDataManger::GetStoreMates()
{
//    QStringList mates;
//    QJsonObject store_mates = _GetFileJson(m_set->value(INIPATH_COMMFILE_MATES).toString());
//    if (store_mates.contains("mates")) {
//        QString mates_str = store_mates["mates"].toString();
//        mates = mates_str.split(",");
//        QLOG_INFO() << "mates: " << mates;
//    }
//    else {
//        QLOG_INFO() << "failed reading mates";
//    }

//    return mates;
    return m_mates;
}

int IniDataManger::GetMaxRetry() const
{
    return m_userSet->value(INIPATH_MAX_RETRY).toInt();
}

void IniDataManger::SetSqlServerInfo(const IniDataManger::SqlServerInfo& sqlInfo)
{
    m_userSet->setValue(INIPATH_SQL_HOST, sqlInfo.host);
    m_userSet->setValue(INIPATH_SQL_USERNAME, sqlInfo.username);
    m_userSet->setValue(INIPATH_SQL_PASSWORD, sqlInfo.password);
    m_userSet->setValue(INIPATH_SQL_DATABASE, sqlInfo.database);
    return;
}

void IniDataManger::SetPrinterName(const QString& name)
{
    m_fmps->setValue(INIPATH_PRINTER_NAME, QString::fromLocal8Bit(name.toLocal8Bit().data()));
    return;
}

void IniDataManger::SetStoreJson(const QJsonObject &json)
{
    m_storeJson =  json;
}

QString IniDataManger::GetDbServerUrl()
{
    return m_set->value("DbServer/url").toString();
}

void IniDataManger::SetMates(const QStringList &mates)
{
    m_mates = mates;
}

IniDataManger::IniDataManger()
{
    QString iniPath = QString("%1/%2").arg(QApplication::applicationDirPath()).arg(INI_FILE_NAME);
    qDebug(iniPath.toStdString().data());
    if(!QFile(iniPath).exists())
    {
        QLOG_WARN() << QString("can't find ini file![%1]").arg(iniPath);
    }
    m_set = new QSettings(iniPath, QSettings::IniFormat);
    m_set->setIniCodec(QTextCodec::codecForName("UTF-8"));

    iniPath = QString("%1/%2").arg(QApplication::applicationDirPath()).arg(USERINI_FILE_NAME);
    if(!QFile(iniPath).exists())
    {
        QLOG_WARN() << QString("can't find user ini file![%1]").arg(iniPath);
    }
    m_userSet = new QSettings(iniPath, QSettings::IniFormat);

    iniPath = QString("%1/printer.ini").arg(QApplication::applicationDirPath());
    if(!QFile(iniPath).exists())
    {
        QLOG_WARN() << QString("can't find printer ini file![%1]").arg(iniPath);
    }
    m_fmps = new QSettings(iniPath, QSettings::IniFormat);
}

QJsonObject IniDataManger::_GetFileJson(const QString &file_path)
{
    QFile file(qApp->applicationDirPath() + "/" + file_path);
    if (file.exists() && file.open(QFile::ReadOnly)) {
        QLOG_INFO() << file_path << " read ok.";
        QByteArray content = file.readAll();
        //QJson::Parser p;
        QJsonParseError ok;
        //QVariantMap v = p.parse(content, &ok).toMap();
        QJsonObject v = QJsonDocument::fromJson(content, &ok).object();
        if (ok.error == QJsonParseError::NoError) {
            QLOG_INFO() << file_path << " parsed ok.";
        }
        else {
            QLOG_WARN() << file_path << " parsed failed.";
        }

        file.close();
        return v;
    }
    else {
        QLOG_WARN() << file_path << " read failed.";
        return QJsonObject();
    }
}

QString IniDataManger::GetPOSServerIP()
{
    return m_set->value("POSServer/serverIp", "").toString();
}

QString  IniDataManger::GetPOSStoreName()
{
    return m_set->value("POSServer/storeName", "").toString();
}

QString IniDataManger::GetPOSLocalPrinterPort()
{
    return m_set->value("POSServer/localPrinterPort", "").toString();
}

int IniDataManger::GetPOSLocalPrinterBaud()
{
    return m_set->value("POSServer/localPrinterBaud", "").toInt();
}
