#ifndef MATECHOOSER_H
#define MATECHOOSER_H

#include <QButtonGroup>
#include <QDialog>
#include "../QsLog/QsLog.h"

namespace Ui {
class MateChooser;
}

class QTreeWidgetItem;
class ComdObject;

class MateChooser : public QDialog
{
    Q_OBJECT

public:
    explicit MateChooser(QWidget *parent = 0);
    ~MateChooser();

    void        setTitle(const QString &t);
    QString     getTitle() const;

    QList<ComdObject *>     candidates();
    void                    setMates(const QList<ComdObject *> &pendingMates,
                                     QList<ComdObject *> &assignedMates);
    QList<ComdObject *>     selectedMates() const;

public slots:
    void        on_mateCancel_clicked();
    void        on_mateConfirm_clicked();
    void        onMateItemClicked(QAbstractButton *item);

private:
    Ui::MateChooser *ui;
    QButtonGroup    _group;

    QList<ComdObject *>         _selected_mates;
    QMap<QString, ComdObject*>  _candidates_map;
};

#endif // MATECHOOSER_H
