#ifndef ORDEROBJECT_H
#define ORDEROBJECT_H

#include "DataObject.h"
#include "ComdObject.h"
#include <QJsonArray>
#include <QJsonObject>
#include <QVariant>
#include <QJsonDocument>
#include <QJsonParseError>

class OrderObject : public DataObject
{
    Q_OBJECT
public:
    explicit OrderObject(QObject *parent = 0)
        :DataObject(parent),
         delivery_status(0),
         delivery_type(1),
         has_mate(false),
         mate_assigned(false),
         billed(false)
    {}

    Q_PROPERTY (QString channel READ getChannel WRITE setChannel)
    Q_PROPERTY (QString channelName READ getChannelName WRITE setChannelName)
    Q_PROPERTY (QString phone READ getPhone WRITE setPhone)
    Q_PROPERTY (QString address READ getAddress WRITE setAddress)
    Q_PROPERTY (QString customer READ getCustomer WRITE setCustomer)
    Q_PROPERTY (QString delivery_party READ getDeliveryParty WRITE setDeliveryParty)
    Q_PROPERTY (QString order_id READ getOrderId WRITE setOrderId)
    Q_PROPERTY (QString posorder_id READ getPosOrderId WRITE setPosOrderId)
    Q_PROPERTY (QString coupon READ getCoupon WRITE setCoupon)
    Q_PROPERTY (QString remark READ getRemark WRITE setRemark)
    Q_PROPERTY (QString timestamp READ getTimestamp WRITE setTimestamp)
    Q_PROPERTY (QString pay_type READ getPayType WRITE setPayType)
    Q_PROPERTY (QString printcfg READ getprintcfg WRITE setprintcfg)
    Q_PROPERTY (int paid_fee READ getPaidFee WRITE setPaidFee)
    Q_PROPERTY (int rest_fee READ getRestFee WRITE setRestFee)
    Q_PROPERTY (int user_fee READ getUserFee WRITE setUserFee)
    Q_PROPERTY (int shop_fee READ getShopFee WRITE setShopFee)

    Q_PROPERTY (int product_fee READ getProductFee WRITE setProductFee)
    Q_PROPERTY (int service_fee READ getServiceFee WRITE setServiceFee)

    Q_PROPERTY (int status READ getStatus WRITE setStatus)
    Q_PROPERTY (int create_time READ getCreateTime WRITE setCreateTime)
    Q_PROPERTY (int expire_time READ getExpireTime WRITE setExpireTime)
    Q_PROPERTY (int total_fee READ getTotalFee WRITE setTotalFee)
    Q_PROPERTY (int discount_fee READ getDiscountFee WRITE setDiscountFee)
    Q_PROPERTY (int dis_shop_fee READ getDisShopFee WRITE setDisShopFee)
    Q_PROPERTY (int send_fee READ getSendFee WRITE setSendFee)
    Q_PROPERTY (int total_amount READ getTotalAmount WRITE setTotalAmount)
    Q_PROPERTY (int order_index READ getOrderIndex WRITE setOrderIndex)
    Q_PROPERTY (int delivery_status READ getDeliveryStatus WRITE setDeliveryStatus)
    Q_PROPERTY (QString fm_id READ getFmId WRITE setFmId)
    Q_PROPERTY (QString status_desc READ getStatusDesc WRITE setStatusDesc)
    Q_PROPERTY (int delivery_type READ getDeliveryType WRITE setDeliveryType)
    Q_PROPERTY (quint32 delivery_time READ getDeliveryTime WRITE setDeliveryTime)

    //! Offline property
    Q_PROPERTY (bool has_mate READ getHasMate WRITE setHasMate)
    Q_PROPERTY (bool mate_assigned READ getMateAssigned WRITE setMateAssigned)
    Q_PROPERTY (bool billed READ getBilled WRITE setBilled)
    Q_PROPERTY (QString bill_file READ getBillFile WRITE setBillFile)

    Q_PROPERTY (int package_fee READ getpackage_fee WRITE setpackage_fee)

    Q_PROPERTY (QString invoice_title READ getInvoiceTitle WRITE setInvoiceTitle)

    Q_PROPERTY (QStringList dis_desc READ getdis_desc WRITE setdis_desc)

protected:
    QStringList getdis_desc() const;
    void setdis_desc(const QStringList& v);

    int getpackage_fee() const ;
    void setpackage_fee(const int& v);

    int         getStatus() const ;
    void        setStatus(const int& v);

    QString     getChannel() const ;
    void        setChannel(const QString& v);

    QString     getChannelName() const ;
    void        setChannelName(const QString& v);

    QString     getPhone() const ;
    void        setPhone(const QString& v);

    QString     getAddress() const ;
    void        setAddress(const QString& v);

    QString     getCustomer() const ;
    void        setCustomer(const QString& v);

    QString     getDeliveryParty() const ;
    void        setDeliveryParty(const QString& v);

    QString     getOrderId() const ;
    void        setOrderId(const QString& v);

    QString     getPosOrderId() const ;
    void        setPosOrderId(const QString& v);

    int         getPaidFee() const ;
    void        setPaidFee(const int& v);

    int         getShopFee() const ;
    void        setShopFee(const int& v);

    int         getRestFee() const ;
    void        setRestFee(const int& v);

    int         getUserFee() const ;
    void        setUserFee(const int& v);

    QString     getCoupon() const ;
    void        setCoupon(const QString& v);

    QString     getRemark() const ;
    void        setRemark(const QString& v);

    int         getCreateTime() const ;
    void        setCreateTime(const int& v);

    int         getExpireTime() const ;
    void        setExpireTime(const int& v);

    QString     getTimestamp() const ;
    void        setTimestamp(const QString& v);

    QString     getPayType() const ;
    void        setPayType(const QString& v);

    QString     getprintcfg() const ;
    void        setprintcfg(const QString& v);

    int         getTotalFee() const ;
    void        setTotalFee(const int& v);

    int         getDiscountFee() const ;
    void        setDiscountFee(const int& v);

    int         getDisShopFee() const ;
    void        setDisShopFee(const int& v);

    int         getSendFee() const ;
    void        setSendFee(const int& v);

    int         getServiceFee() const;
    void        setServiceFee(const int v);

    int         getProductFee() const;
    void        setProductFee(const int v);

    int         getTotalAmount() const ;
    void        setTotalAmount(const int& v);

    int         getOrderIndex() const ;
    void        setOrderIndex(const int v);

    int         getDeliveryStatus() const;
    void        setDeliveryStatus(const int v);

    QString     getFmId() const;
    void        setFmId(const QString &v);

    QString     getStatusDesc() const;
    void        setStatusDesc(const QString &v);

    int         getDeliveryType() const;
    void        setDeliveryType(const int v);

    quint32     getDeliveryTime() const;
    void        setDeliveryTime(quint32 v);

    bool        getHasMate() const;
    void        setHasMate(bool v);

    bool        getMateAssigned() const;
    void        setMateAssigned(bool v);

    bool        getBilled() const;
    void        setBilled(bool v);

    QString     getBillFile() const;
    void        setBillFile(const QString &v);

    QString     getInvoiceTitle() const ;
    void        setInvoiceTitle(const QString& v);

    QList<ComdObject*>  _ReadObjectMates(const QString &mates_str);

public:
    ComdObject         *MatchObjectsFromBill(const QJsonArray &products);
    void                CheckIfMatesAssigned();

public:
    QByteArray  toString() const
    {
        QJsonObject json = toJson();

        QJsonArray ComdsArray;
        foreach ( ComdObject *v, proList) {
            QJsonObject o = v->toJson();
            ComdsArray.append(o);
        }
        json["products"] = ComdsArray;

        QByteArray data = QJsonDocument(json).toJson();

        return data;
    }

    void        fromJson(const QJsonObject &json);
    void        fromString( const QByteArray& str);

    void        getProList( QList<ComdObject *> &list);
    void        setMateList( QList<ComdObject *> &list);


public:
    QList<ComdObject *> proList;
    QList<ComdObject *> mateList;           //所有的加料
    QList<ComdObject *> assignedMateList;   //已经分配的加料
    QList<ComdObject *> loneMateList;       //多余的加料(无法再分配)ss

    QMap<ComdObject*, QList<ComdObject*> >  pvm;            //<产品, 加料列表> Map

    int status;              //订单状态
    QString channel;         //渠道
    QString channelName;     //渠道名称
    int order_index;     //渠道当天序号
    QString phone;           //电话
    QString address;         //地址
    QString customer;        //用户姓名
    QString delivery_party;  //派送方式
    int delivery_status;     //派送状态
    QString fm_id;           //Freemud order id
    QString status_desc;     //Order status description
    int delivery_type;       //Delivery type
    int delivery_time;   //Delivery time
    QString bill_file;       //Bill file
    QString invoice_title;     //发票抬头

    int paid_fee;            //已付金额
    int rest_fee;            //未付
    int user_fee;            //应付金额
    int shop_fee;            //应收金额(商家和骑士看到的)
    int service_fee;         //平台服务费
    int product_fee;         //商品总价
    QString order_id;        //订单号
    QString posorder_id;     //pos订单号
    QString remark;          //备注
    int create_time;         //订单时间
    QString coupon;          //码
    QString timestamp;       //时间戳
    int expire_time;         //订单倒计时
    QString printcfg;        //打印联

    QString pay_type;        //支付方式

    int total_fee;           //商品金额
    int discount_fee;        //商品优惠
    int dis_shop_fee;        //商户优惠
    int send_fee;            //运费金额
    int total_amount;        //总件数

    int package_fee;         //打包费

    QStringList dis_desc;        //赠送商品信息

    QString ebcode;
    QString vdata;
    bool has_mate;           // Has extra mate products
    bool mate_assigned;
    bool billed;             // Specify if order has been billed
};

#endif // ORDEROBJECT_H
