#include "Tools.h"
#include "PreDefined.h"

QString UnitConver(int penny, int precision)
{
    double tmp = (double)penny/100;
    return QString::number(tmp,'f',precision);
}

QString GetOperaBtnNameByVID(int vid)
{
    QString operaBtn_name;
    switch(vid)
    {
    case TABLE_VID_RESERVATION:
        operaBtn_name = OPERABTN_NAME_MAKE;
        break;
    case TABLE_VID_SHIPSELF:
        operaBtn_name = OPERABTN_NAME_CONFIRM;
        break;
    case TABLE_VID_MAKING:
        operaBtn_name = OPERABTN_NAME_SEND;
        break;
    case TABLE_VID_SELF_MAKING:
        operaBtn_name = OPERABTN_NAME_SELFSEND;
        break;
    case TABLE_VID_CONFIRM_MATE:
        operaBtn_name = OPERABTN_NAME_CONFIRM_MATE;
        break;
    case TABLE_VID_SHIPING:
    case TABLE_VID_SELF_SHIPING:
        operaBtn_name = OPERABTN_NAME_COMPLETE;
        break;
    default:
        operaBtn_name = OPERABTN_NAME_DEAFULT;
        break;
    }

    return operaBtn_name;
}

QString GetOrderStatusName(int status, int dstatus)
{
    QString status_name;
    switch(status)
    {
    case ORDERSTATUS_NEW:
        status_name = "未处理";
        break;
    case ORDERSTATUS_CONFIRMED:
        if (SHIPSTATUS_CANCELED == dstatus) {
            status_name = "未处理";
        }
        else {
            status_name = "制作中";
        }
        break;
    case ORDERSTATUS_CANCELED:
        status_name = "已取消";
        break;
    case ORDERSTATUS_SHIPPING:
    case ORDERSTATUS_SHIP_PENDING:
        status_name = "配送中";
        break;
    case ORDERSTATUS_ARRIVED:
    case ORDERSTATUS_COMPLETE:
        status_name = "已完成";
        break;
    case ORDERSTATUS_LOCKED:
        status_name = "已锁定";
        break;
    case ORDERSTATUS_REFUND:
        status_name = "退款";
        break;
    case ORDERSTATUS_REFUND_COMPLETE:
        status_name = "已退款";
        break;
    default:
        status_name = "未知状态";
        break;
    }
    return status_name;
}


QString GetOperaBtnStyleByVID(int vid, const QString &channel)
{
    QString qss = "QPushButton {border-image: none; border-radius: 6px; background: %1; color: %2; }"
                  "QPushButton:pressed { padding: 1 0 0 2; }";
    QString color = "rgb(230,230,230)", text_color = "rgb(98,98,98)", red_color = "rgb(200, 40, 40)";
    switch(vid)
    {
    case TABLE_VID_SHIPSELF:
        color = red_color;
        text_color = "white";
        break;
    case TABLE_VID_MAKING:
        if (channel == CHANNEL_ID_BD) {
            color = red_color;
            text_color = "white";
        }
        break;
    case TABLE_VID_SELF_MAKING:
        color = red_color;
        text_color = "white";
        break;
    case TABLE_VID_CONFIRM_MATE:
        color = "rgb(74, 203, 165)";
        text_color = "white";
        break;
    case TABLE_VID_SHIPING:
        break;
    case TABLE_VID_SELF_SHIPING:
        color = red_color;
        text_color = "white";
        break;
    default:
        color = "rgb(230,230,230)";
        break;
    }

    qss = qss.arg(color, text_color);

    return qss;
}
