#include "FloatForm.h"
#include "ui_FloatForm.h"
#include "PreDefined.h"

#include <QTimer>
#include <QSettings>
#include <QApplication>
#include "Util/IniDataManger.h"

#include <QDebug>


FloatForm::FloatForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FloatForm)
{
    ui->setupUi(this);

    m_bBlink = false;

    m_soundIndex = 0;
    //m_sound = new QSound(QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath()), this);
    m_soundTimer = new QTimer(this);
    m_soundTimer->setInterval(1000);
    connect(m_soundTimer, SIGNAL(timeout()), this, SLOT(onSoundTimeOut()));

    m_raiseTimer = new QTimer(this);
    connect(m_raiseTimer, SIGNAL(timeout()), this, SLOT(raise()));
    m_raiseTimer->start(1000);

    m_blinkTimer = new QTimer(this);
    connect(m_blinkTimer, SIGNAL(timeout()), this, SLOT(onBlinkTimerOut()));
    m_blinkTimer->setInterval(100);

    this->setWindowFlags(windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);


    //this->setAttribute(Qt::WA_TranslucentBackground);
    //setAttribute(Qt::WA_NoSystemBackground);
    //setAttribute(Qt::WA_PaintOnScreen);

    this->move(OBJREF(IniDataManger).GetFloatPos());

    QPixmap mapNormal(":/images/float_normal.png");
    m_imgNormal = mapNormal.size();
    QPixmap mapNotify(":/images/float_new.png");
    m_imgNotifyNew = mapNotify.size();

    _qss_notify_normal  = "#floatBtnLogo{ border-image: url(:/images/float_normal.png);}";
    _qss_notify_new     = "#floatBtnLogo{ border-image: url(:/images/float_new.png);}";
    _qss_notify_mates   = "#floatBtnLogo{ border-image: url(:/images/float_mates.png);}";
    _qss_notify_refund  = "#floatBtnLogo{ border-image: url(:/images/float_refund.png);}";

    this->setFixedSize(m_imgNormal);
    ui->floatBtnLogo->setStyleSheet(_qss_notify_normal);

    m_animation = new QPropertyAnimation(this, "windowOpacity");
    m_animation->setDuration(OBJREF(IniDataManger).GetBlinkInterval()*1000);
    m_animation->setEasingCurve(QEasingCurve::InOutSine);

    connect(ui->floatBtnLogo, SIGNAL(bMoved(QPoint)), this, SIGNAL(bMoved(QPoint)));
}

FloatForm::~FloatForm()
{
    delete ui;
}

void FloatForm::onStartBlink(int table_id)
{
    qDebug() <<__FUNCTION__;
    if(!m_bBlink)
    {
        m_bBlink = true;
        _vid = table_id;
        m_blinkTimer->start();
        //m_sound->play();
        m_soundTimer->start();
    }

    return;
}

void FloatForm::onStopBlink()
{
    m_blinkTimer->stop();
    m_soundTimer->stop();
    m_bBlink = false;
    return;
}

void FloatForm::onSoundTimeOut()
{
//    if(m_sound->isFinished())
//    {
//        if(++m_soundIndex >= OBJREF(IniDataManger).GetSoundInterval())
//        {
//            m_soundIndex = 0;
//            m_sound->play();
//        }
//    }
}

void FloatForm::onBlinkTimerOut()
{
    QEventLoop loop;
    connect(m_animation, SIGNAL(finished()), &loop, SLOT(quit()));
    m_animation->setStartValue(1);
    m_animation->setEndValue(0);
    m_animation->start();
    loop.exec();
    this->setFixedSize(m_imgNotifyNew);

    switch(_vid) {
    case TABLE_VID_MAKING:
    case TABLE_VID_SELF_MAKING:
        ui->floatBtnLogo->setStyleSheet(_qss_notify_new);
        break;
    case TABLE_VID_CONFIRM_MATE:
        ui->floatBtnLogo->setStyleSheet(_qss_notify_mates);
        break;
    case TABLE_VID_REFUND:
    case TABLE_VID_SELF_REFUND:
        ui->floatBtnLogo->setStyleSheet(_qss_notify_refund);
        break;
    default:
        ui->floatBtnLogo->setStyleSheet(_qss_notify_new);
        break;
    }

    m_animation->setStartValue(0);
    m_animation->setEndValue(1);
    m_animation->start();
    loop.exec();
    m_animation->setStartValue(1);
    m_animation->setEndValue(0);
    m_animation->start();
    loop.exec();
    this->setFixedSize(m_imgNormal);
    ui->floatBtnLogo->setStyleSheet(_qss_notify_normal);
    m_animation->setStartValue(0);
    m_animation->setEndValue(1);
    m_animation->start();
    loop.exec();
}

void FloatForm::on_floatBtnLogo_clicked()
{
    this->hide();
    emit mainFormShow();
    return;
}

