#include "OperaForm.h"
#include "ui_OperaForm.h"
#include <QPushButton>
#include "PreDefined.h"
#include "../QsLog/QsLog.h"

OperaForm::OperaForm(const QList<FmTakeaway_db::OperatorInfo> &listOperator, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OperaForm)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint);
    //this->setAttribute(Qt::WA_TranslucentBackground);
    //setAttribute(Qt::WA_NoSystemBackground);
    //setAttribute(Qt::WA_PaintOnScreen);

    this->setGeometry(parent->geometry());

    if(0!=listOperator.count())
    {
        for(int i=0; i<listOperator.count(); i++)
        {
            QPushButton* btn = NULL;
            btn = this->findChild<QPushButton*>(QString("operaBtn%1").arg(i));
            connect(btn, SIGNAL(toggled(bool)), this, SLOT(onBtnToggled(bool)));
            if(NULL!=btn)
            {
                btn->setText(listOperator.at(i).name);
                btn->setProperty(PROPERTY_BTNSELECT_NAME, listOperator.at(i).name);
                btn->setProperty(PROPERTY_BTNSELECT_ID, listOperator.at(i).id);
                btn->setProperty(PROPERTY_BTNSELECT_SHIFTID, listOperator.at(i).shiftId);
                btn->setProperty(PROPERTY_BTNSELECT_SHIFTNAME, listOperator.at(i).shiftName);

                btn->setEnabled(true);
            }
        }
    }

    m_prevBtn = NULL;

    ui->operaBtnOk->setEnabled(false);

    connect(ui->operaBtnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->operaBtnCancle, SIGNAL(clicked()), this, SLOT(reject()));
}

OperaForm::~OperaForm()
{
    delete ui;
}

FmTakeaway_db::OperatorInfo OperaForm::GetOperator()
{
    return m_operator;
}

void OperaForm::onBtnToggled(bool bChecked)
{
    QPushButton *targetBtn = (QPushButton*)sender();

    if(bChecked)
    {
        if(NULL!=m_prevBtn && m_prevBtn!=targetBtn)
        {
            m_prevBtn->setChecked(false);
        }
        m_prevBtn = targetBtn;
        m_operator.name = targetBtn->property(PROPERTY_BTNSELECT_NAME).toString();
        m_operator.id = targetBtn->property(PROPERTY_BTNSELECT_ID).toString();
        m_operator.shiftId = targetBtn->property(PROPERTY_BTNSELECT_SHIFTID).toString();
        m_operator.shiftName = targetBtn->property(PROPERTY_BTNSELECT_SHIFTNAME).toString();

        ui->operaBtnOk->setEnabled(true);
    }else
    {
        ui->operaBtnOk->setEnabled(false);
    }
}
