#ifndef UDPNOTIFIER_H
#define UDPNOTIFIER_H

#include <QUdpSocket>
#include <QHostInfo>

class UdpNotifier : public QUdpSocket
{
    Q_OBJECT
public:
    static UdpNotifier& Instance();

    bool Start(int);

    // 通知局域网内其他用户关闭接单功能
    void NotifyOther();

private:
    UdpNotifier():m_udpPort(-1){}
    UdpNotifier(UdpNotifier const&);
    UdpNotifier& operator=(UdpNotifier const&);

    bool _CreateServer();

    QUdpSocket *m_udpServer;
    int m_udpPort;

private slots:
    void onRecvData();

signals:
    void udpError(QString);
    void beSlave();
};


#endif // UDPNOTIFIER_H
