#include "DeliversForm.h"
#include "ui_DeliversForm.h"
#include <QDebug>

DeliversForm::DeliversForm(const QList<DeliverObject> &listDelivers, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DeliversForm)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint);
    //this->setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);
    //setAttribute(Qt::WA_NoSystemBackground);
    //setAttribute(Qt::WA_PaintOnScreen);

    this->setGeometry(parent->geometry());

    for(int i=0; i<listDelivers.count(); i++)
    {
        QPushButton* btn = NULL;
        btn = this->findChild<QPushButton*>(QString("deliversBtn%1").arg(i));
        connect(btn, SIGNAL(toggled(bool)), this, SLOT(onBtnToggled(bool)));
        if(NULL!=btn)
        {
            btn->setText(listDelivers.at(i).name);
            btn->setProperty("id", listDelivers.at(i).id);
            btn->setProperty("name", listDelivers.at(i).name);
            btn->setProperty("phone", listDelivers.at(i).phone);

            btn->setEnabled(true);
        }
    }

    m_prevBtn = NULL;

    ui->deliversBtnOk->setEnabled(false);
    connect(ui->deliversBtnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->deliversBtnCancle, SIGNAL(clicked()), this, SLOT(reject()));
}

DeliversForm::~DeliversForm()
{
    delete ui;
}

DeliverObject DeliversForm::GetDeliver()
{
    return m_deliverObj;
}

void DeliversForm::onBtnToggled(bool bChecked)
{
    QPushButton *targetBtn = (QPushButton*)sender();

    if(bChecked)
    {
        if(NULL!=m_prevBtn && m_prevBtn!=targetBtn)
        {
            m_prevBtn->setChecked(false);
        }
        m_prevBtn = targetBtn;
        m_deliverObj.name = targetBtn->property("name").toString();
        m_deliverObj.id = targetBtn->property("id").toString();
        m_deliverObj.phone = targetBtn->property("phone").toString();

        ui->deliversBtnOk->setEnabled(true);
    }else
    {
        ui->deliversBtnOk->setEnabled(false);
    }
}
