#include "DMvButton.h"
#include <QDebug>

DMvButton::DMvButton(QWidget *parent)
    : QPushButton(parent),
      m_bMouseMove(false),
      m_bMousePress(false),
      m_parent(parent)
{
}

void DMvButton::mouseMoveEvent(QMouseEvent *e)
{
    if ((e->buttons()==Qt::LeftButton) && m_bMousePress)
    {
        m_absMove += e->globalPos() - m_lastMousePos;
        QPoint desPos = m_parent->pos() + e->globalPos() - m_lastMousePos;
        m_parent->move(desPos);
        m_lastMousePos = e->globalPos();

        m_bMouseMove = true;
    }
    return;
}

void DMvButton::mousePressEvent(QMouseEvent *e)
{
    if (e->button()==Qt::LeftButton)
    {
        m_bMousePress = true;
        m_lastMousePos = e->globalPos();
        m_absMove = QPoint(0,0);
    }

    QPushButton::mousePressEvent(e);
    return;
}

void DMvButton::mouseReleaseEvent(QMouseEvent *e)
{
    if (e->button()==Qt::LeftButton)
    {
        m_bMousePress = false;
    }
    int x = m_absMove.x();
    int y = m_absMove.y();
    if(!m_bMouseMove || (((x>-10)&&(x<10))&&((y>-10)&&(y<10))))
    {
         QPushButton::mouseReleaseEvent(e);
    }

    emit bMoved(((QWidget*)this->parent())->pos());
    m_bMouseMove = false;
    return;
}
