#include "ReqDataManger.h"

#include "PreDefined.h"
#include "../fmTakeaway_db/FmTakeaway_db.h"
#include "NotifyForm.h"
#include "IniDataManger.h"
#include <QFile>
#include <QApplication>
#include "QsLog.h"
#include "wbillcontrol.h"
#include <QDebug>

enum{LOGIN=10, PULL_ORDER, CONFIRM_ORDER,
    REFUSE_ORDER, BIND_POS_ORDER, SET_POS_NUM,
    TAKEAWAY_ACV, AGREE_REFUND, CANCEL_REFUND,
    SEND_ORDER, GET_DELIVER=21,WRITE_OFF=71, UPDATE_STOCK=80};

ReqDataManger &ReqDataManger::Instance()
{
    static ReqDataManger reqDataManger;
    return reqDataManger;
}

void ReqDataManger::SetToken(const QString &token)
{
    m_token = token;
}

QByteArray ReqDataManger::GetLoginData()
{

    IniDataManger::LoginInfo loginInfo;
    loginInfo = OBJREF(IniDataManger).GetLoginInfo();
    QJsonObject dd = OBJREF(IniDataManger).GetStoreJson();
    QJsonObject store = dd["store_info"].toObject();

    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_USERNAME, FmTakeaway_db::Instance().GetBranchNum());
    QString store_id = OBJREF(IniDataManger).GetStoreIdPrefix();
    store_id += store["store_id"].toString();
    QString username, posId;
    if(store["partner_id"].toString().isEmpty())
    {
        posId = store["pos_id"].toString();
        QString storeId = posId.mid(0, posId.length()-4);
        username = store["store_id"].toString()+storeId;
        posId = posId.right(4);
        WBillControl::GetInstance().SetStoreInfo(store["store_id"].toString(), storeId, store["operator_id"].toString(), posId, store["business_date"].toString());
    }else
    {
        username = /*store["partner_id"].toString()+*/store["store_id"].toString();
        posId = store["pos_id"].toString();
    }
    cObj.insert(JSON_KEY_USERNAME, username);
    cObj.insert(JSON_KEY_PASSWORD, loginInfo.password);
    rootObj.insert(JSON_KEY_REQTYPE, LOGIN);
    rootObj.insert(JSON_KEY_CURRENTUSER, cObj);
    rootObj.insert(JSON_KEY_STATIONID, posId);
    rootObj.insert(JSON_KEY_OPERATORID, store["operator_id"].toString());
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();
    qDebug()<<json;
    return json;
}

QByteArray ReqDataManger::GetPullOrderData(const QString &timestamp)
{
//    QJsonObject rootObj;
    QJsonObject rootObj;
    rootObj.insert(JSON_KEY_REQTYPE, PULL_ORDER);
    rootObj.insert(JSON_KEY_TIMESTAMPS, timestamp);
    rootObj.insert(JSON_KEY_AUTOCONFIRM, 1);
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray ReqDataManger::GetConfirmOrderData(const QString &orderId, const QString &id, const QString &name, const QString &phone)
{
//    QJsonObject rootObj, cObj;
    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_ORDERID, orderId);
    cObj.insert(JSON_KEY_DELIVERYID, id);
    cObj.insert(JSON_KEY_DELIVERYNAME, name);
    cObj.insert(JSON_KEY_DELIVERYPHONE, phone);
    cObj.insert(JSON_KEY_DELIVERYTYPE, 0);
    rootObj.insert(JSON_KEY_REQTYPE, 22);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();
    return json;
}

QByteArray ReqDataManger::GetRefuseOrderData(int reasonCode, const QString &orderId)
{
//    QJsonObject rootObj, cObj;
    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_ORDERID, orderId);
    cObj.insert(JSON_KEY_REASONCODE, reasonCode);
    rootObj.insert(JSON_KEY_REQTYPE, REFUSE_ORDER);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray  ReqDataManger::GetSendOrderData(const QString &orderId)
{
//    QJsonObject rootObj, cObj;
    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_ORDERID, orderId);
    //cObj.insert(JSON_KEY_DELIVERYTYPE, "0");
    rootObj.insert(JSON_KEY_REQTYPE, SEND_ORDER);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray ReqDataManger::GetOrderFinshData(const QString &orderId)
{
//    QJsonObject rootObj, cObj;
    QJsonObject rootObj, cObj;

    cObj.insert(JSON_KEY_ORDERID, orderId);
    rootObj.insert(JSON_KEY_REQTYPE, TAKEAWAY_ACV);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;


    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray ReqDataManger::GetDeliverData(const QString &storeId)
{
//    QJsonObject rootObj;
    QJsonObject rootObj, cObj;
    rootObj.insert(JSON_KEY_REQTYPE, GET_DELIVER);
//    rootObj.insert(JSON_KEY_STOREID, storeId);
    rootObj.insert(JSON_KEY_STOREID, "fm9999");
    rootObj.insert(JSON_KEY_TOKEN, m_token);
//    return rootObj;

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray ReqDataManger::GetRefundOrderData(const QString &orderId, const QString &reason)
{
    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_ORDERID, orderId);
    cObj.insert("reason", reason);
    rootObj.insert(JSON_KEY_REQTYPE, AGREE_REFUND);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}

QByteArray ReqDataManger::GetNoRefundOrderData(const QString &orderId, const QString &reason)
{
    QJsonObject rootObj, cObj;
    cObj.insert(JSON_KEY_ORDERID, orderId);
    cObj.insert("reason", reason);
    rootObj.insert(JSON_KEY_REQTYPE, CANCEL_REFUND);
    rootObj.insert(JSON_KEY_ORDER, cObj);
    rootObj.insert(JSON_KEY_TOKEN, m_token);

    QByteArray json = QJsonDocument(rootObj).toJson();

    return json;
}
