#include "NotifyForm.h"
#include "ui_NotifyForm.h"

#include <QMovie>
#include <QDesktopWidget>
#include "../QsLog/QsLog.h"

NotifyForm::NotifyForm(QString strMsg, NotifyForm::Type type, QWidget *parent):
    ui(new Ui::NotifyForm),
    QDialog(parent)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint);
    //this->setAttribute(Qt::WA_TranslucentBackground);
    //setAttribute(Qt::WA_NoSystemBackground);
    //setAttribute(Qt::WA_PaintOnScreen);
    setAttribute(Qt::WA_QuitOnClose, false);

    // 初始化Gif动画
    m_movie = new QMovie(this);
    m_movie->setFileName(":/images/load.gif");
    ui->notifyLabMov->setMovie(m_movie);
    ui->notifyLabMov->setScaledContents(true);
    m_movie->start();

    _Init(strMsg, type);

    QDesktopWidget w;
    QRect rc = w.availableGeometry();
    setGeometry((rc.width() - width()) / 2, (rc.height() - height()) / 2, width(), height());
}

NotifyForm::~NotifyForm()
{
    delete ui;
}

void NotifyForm::SetAutoClose(int seconds)
{
    if (ui->notifyLabExtra->text().isEmpty() || !m_btn_text.contains("自配送")) {
        m_ac_timeline.setDuration(seconds * 1000);
        m_ac_timeline.setFrameRange(1, 5);
        m_ac_timeline.setDirection(QTimeLine::Backward);
        connect(&m_ac_timeline, SIGNAL(finished()), SLOT(on_notifyBtnOk_clicked()));
        connect(&m_ac_timeline, SIGNAL(frameChanged(int)), SLOT(onCountDown(int)));
        m_ac_timeline.start();
    }
}

void NotifyForm::SetExtraInfo(const QString &tip)
{
    ui->notifyLabExtra->setText(tip);
}

void NotifyForm::_Init(QString strMsg, NotifyForm::Type type)
{
    if(NotifyForm::LOADING==type)
    {
        ui->notifyBtnOk->hide();
        ui->notifyLabMov->show();
        ui->notifyBtnImg->hide();
    }else
    {
        ui->notifyBtnOk->show();
        ui->notifyLabMov->hide();
        ui->notifyBtnImg->show();
    }

    // 图片
    if(NotifyForm::OK==type)
    {
        ui->notifyBtnImg->setChecked(true);
    }else if(NotifyForm::ERROR==type)
    {
        ui->notifyBtnImg->setChecked(false);
    }

    // 文字
    ui->notifyLabMsg->setText(strMsg);

    if (strMsg.contains("自配送") && NotifyForm::OK==type) {
        ui->notifyBtnOk->setText("送出/印杯贴");
        ui->notifyBtnOk->setGeometry(x(), y(), width() + 20, height());
    }

    m_btn_text = ui->notifyBtnOk->text();
}

void NotifyForm::onChangeType(QString strMsg, NotifyForm::Type type)
{
    _Init(strMsg, type);
    return;
}

void NotifyForm::on_notifyBtnOk_clicked()
{
    this->accept();
    return;
}

void NotifyForm::onCountDown(int frame)
{
    ui->notifyBtnOk->setText(QString("%1(%2)").arg(m_btn_text, QString::number(frame - 1)));
}
