#include "Database.h"
#include "QsLog.h"
#include <QCoreApplication>

Database::Database()
{
    QString dbpath=QCoreApplication::applicationDirPath()+QString("/Order.db");
    _db=QSqlDatabase::addDatabase("QSQLITE","fm_order_status_table");
    _db.setDatabaseName(dbpath);
    if(!_db.open())
    {
        QString error=_db.lastError().text();
        QLOG_ERROR()<<QString("Qsqlite database open filed,%1").arg(error);
    }

    _nameInfo="OrderInfo";
    _nameProduct="OrderProduct";

    QSqlQuery query(_db);
    QString sqlInfo="CREATE TABLE IF NOT EXISTS " + _nameInfo +" ("
                "fm_id         VARCHAR (40) PRIMARY KEY,"
                "paid_trans_id VARCHAR (40) DEFAULT (''),"
                "pay_ebcode    VARCHAR (40) DEFAULT (''),"
                "pos_order_id  VARCHAR (40) DEFAULT (''),"
                "products_fee  INTEGER      DEFAULT (0),"
                "service_fee   INTEGER      DEFAULT (0),"
                "dis_shop_fee  INTEGER      DEFAULT (0),"
                "isprint       BOOLEAN      DEFAULT (0),"
                "isPosOK       BOOLEAN      DEFAULT (0),"
                "isPosRefundOK BOOLEAN      DEFAULT (0),"
                "addtime       TIMESTAMP    DEFAULT (datetime('now', 'localtime') ) "
                ");";
    if(!query.exec(sqlInfo))
        QLOG_INFO() << " create table failed:"<<sqlInfo;
    else{
        QLOG_INFO() <<QString("create table %1 successed").arg(_nameInfo);
    }

    QString sqlProduct="CREATE TABLE IF NOT EXISTS " + _nameProduct +" ("
                       "fm_id          VARCHAR (40),"
                       "pid            VARCHAR (40) DEFAULT (''),"
                       "consume_num    INTEGER      DEFAULT (0),"
                       "original_price INTEGER      DEFAULT (0), "
                       "addtime        TIMESTAMP    DEFAULT (datetime('now', 'localtime') ) "
                       ");";
    if(!query.exec(sqlProduct))
        QLOG_INFO() << " create table failed:"<<sqlProduct;
    else{
        QLOG_INFO() <<QString("create table %1 successed").arg(_nameProduct);
    }
    delOldData();
}
Database::~Database()
{
    _db.close();
}

Database &Database::getInstance()
{
    static Database order;
    return order;
}

bool Database::execSql(const QString &sql)
{
    QSqlQuery query(_db);
    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() <<sql<< query.lastError();
    return flag;
}

bool Database::isPrint(const QString &orderId)
{
    QSqlQuery query(_db);
    query.prepare(QString("select isprint from OrderInfo where paid_trans_id=%1").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text();
    }
    while(query.next())
    {
        return query.value(0).toBool();
    }
    return false;
}

bool Database::isExit(const QString &orderId)
{
    QSqlQuery query(_db);
    query.prepare(QString("select paid_trans_id from OrderInfo where paid_trans_id=%1").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text();
    }
    if(query.first())
    {
        return true;
    }
    else{
        return false;
    }
}

bool Database::isPosWriteOK(const QString &orderId)
{
    QSqlQuery query(_db);
    query.prepare(QString("select isPosOK from OrderInfo where paid_trans_id=%1").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text();
    }
    while(query.next())
    {
        return query.value(0).toBool();
    }
    return false;
}

QString Database::GetPOSOrderId(const QString &orderId)
{
    QString posOrderId;
    QSqlQuery query(_db);
    query.prepare(QString("select pos_order_id from OrderInfo where paid_trans_id=%1").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text();
    }
    while(query.next())
    {
        posOrderId = query.value(0).toString();
    }
    return posOrderId;
}

QString Database::GetInfoTableName()
{
    return _nameInfo;
}
QString Database::GetProductTableName()
{
    return _nameProduct;
}

void Database::delOldData()
{
    QString delProduct="delete from " + _nameProduct +" where addtime< date('now', '-6 month');";
    QString delOrder="delete from " + _nameInfo +" where addtime< date('now', '-6 month');";
    QSqlQuery query(_db);
    bool flag =  query.exec(delProduct);
    if(!flag)
        QLOG_ERROR() <<"sql exec failed:"<<delProduct<< query.lastError();

    flag =  query.exec(delOrder);
    if(!flag)
        QLOG_ERROR() <<"sql exec failed:"<<delOrder<< query.lastError();
}
