#include "NumpadForm.h"
#include "ui_NumpadForm.h"

NumpadForm::NumpadForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NumpadForm)
{
    ui->setupUi(this);

    this->setWindowFlags(Qt::FramelessWindowHint);
    this->setAttribute(Qt::WA_TranslucentBackground);
    this->move(parent->width()*2/3, parent->height()/3);

    for(int i=0; i<10; i++)
    {
        QPushButton *targetBtn = this->findChild<QPushButton*>(QString("numpadBtn%1").arg(i));
        if(targetBtn!=NULL)
        {
            connect(targetBtn, &QPushButton::clicked, this, &NumpadForm::onNumBtnClicked);
        }
    }

    connect(ui->numpadBtnDel, &QPushButton::clicked, this, &NumpadForm::backInput);

}

NumpadForm::~NumpadForm()
{
    delete ui;
}

void NumpadForm::onNumBtnClicked()
{
    QPushButton *targetBtn = (QPushButton*)sender();
    emit inputNum(targetBtn->property("num").toInt());
}

void NumpadForm::on_numpadBtnCancle_clicked()
{
    emit cleanInput();
    this->hide();
}
