#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <termios.h>
#include <string.h>
#include <iconv.h>
#include <stdlib.h>
#include "pos_print.h"

#define INVALID_HANDLE_VALUE	-1
int g_Handle=INVALID_HANDLE_VALUE;
int g_uBaudrate=0;
int open_port(const char* szPort)
{
    int fd; /* 端口文件描述符 */
    if(g_Handle != INVALID_HANDLE_VALUE)
        close(g_Handle);
    g_Handle= open(szPort, O_RDWR | O_NOCTTY | O_NDELAY);
    
    if (g_Handle == INVALID_HANDLE_VALUE)
         printf("open_port failed\n");
    else
         printf("port is open ok \n");
    return (g_Handle);
}

void set_port(int fd,int Baudrate)
{
    struct termios options;
    int flag;

    tcgetattr(fd, &options);

    fcntl(fd, F_SETFL, 0);
   
    if(9600==Baudrate)
    	g_uBaudrate=B9600;
    else if(19200==Baudrate)
        g_uBaudrate=B19200;
    cfsetispeed(&options, g_uBaudrate);
    cfsetospeed(&options, g_uBaudrate);

    options.c_cflag |= (CLOCAL | CREAD);
    /* Set to 8N1 */
    options.c_cflag &= ~PARENB;
    options.c_cflag &= ~CSTOPB;
    options.c_cflag &= ~CSIZE;
    options.c_cflag |= CS8;

    /* HANDSHAKE 也称为 CRTSCTS */
    options.c_cflag |= CRTSCTS;

    /* RAW */
    options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    options.c_oflag &= ~OPOST;

    /* For read data from printer */
    options.c_cc[VMIN] = 0;
    options.c_cc[VTIME] = 1;

    flag = tcsetattr(fd, TCSANOW, &options);
    if (flag < 0)
    {
        perror("set_port: Setting port /dev/ttyS0 error - ");
    }
}

void close_port()
{
    if (g_Handle != INVALID_HANDLE_VALUE)
    {
	    sleep(1);
	    int res = tcflush(g_Handle,TCIOFLUSH);
            close(g_Handle);
            g_Handle=INVALID_HANDLE_VALUE;
	    g_uBaudrate=0;      
    }

}

void cut_paper()
{
	//char strCutPaper[] = "\x1D\x56\x42\x00";
	char strCutPaper[] = "\x0A\x0A\x0A\x0A\x0A\x0A\x1B\x69\x00";
        write(g_Handle, &strCutPaper, 9);
}

void print(char *data,int type)
{
	printf("data:%s\n",data);
	char *str = (char *)malloc(1024);
	
	if(1==type){
		strcpy(str,"\x1B\x40");
                strcat(str,data);
	}
        else if(2==type){
		strcpy(str,"\x1B\x40");
        	strcat(str,"\x1B\x21\x08");
		strcat(str,data);
		//strcat(str,"\x1B\x21\x00");
        }
        else if(3==type){
		if(B9600==g_uBaudrate){
	                strcpy(str,"\x1B\x40\x1B\x21\x00\x1B\x33\x18\x1B\x52\x00\x1B\x63\x34\x05");
                        strcat(str," \x1C\x57\x01");
                        strcat(str,"\x1B\x21\x30");
                        strcat(str,data);	
		}
		else{
              		strcpy(str,"\x1B\x40");
                	strcat(str,"\x1D\x21\x11");
        	        //strcat(str,"\x1B\x21\x30");
	                strcat(str,data);
		}
        }
        else if(4==type){
                if(B9600==g_uBaudrate){
                        strcpy(str,"\x1B\x40\x1B\x21\x00\x1B\x33\x18\x1B\x52\x00\x1B\x63\x34\x05");
                        strcat(str," \x1C\x57\x01");
                        strcat(str,"\x1B\x21\x38");
                        strcat(str,data);

                }
                else{
                       	strcpy(str,"\x1B\x40");
                	strcat(str,"\x1C\x57\x01");
                	strcat(str,"\x1B\x21\x38");
               		strcat(str,data);
                }
        }
        else if(5==type){
                if(B9600==g_uBaudrate){
                        strcpy(str,"\x1B\x40");
                        strcat(str," \x1C\x57\x01");
                        strcat(str,"\x1B\x21\x38");
                        strcat(str,data);
                }
                else{
               		strcpy(str,"\x1B\x40");
        	        strcat(str,"\x1D\x21\x22");
	                strcat(str,data);
                }
        }
        else if(6==type){
                if(B9600==g_uBaudrate){
                        strcpy(str,"\x1B\x40");
			strcat(str,"\x1C\x57\x01");
                        strcat(str,"\x1B\x21\x38");
                        strcat(str,"\x1B\x72\x01");
                        strcat(str,data);

                }
                else{
                        strcpy(str,"\x1B\x40");
                	strcat(str,"\x1D\x21\x22");
                	strcat(str,"\x1B\x72\x01");
                	strcat(str,data);

                }
		//strcat(str,"\x1B\x72\x00");
               // strcat(str,"\x1B\x21\x00");
        }
	
	//char str[300];
	//strcpy(str,data);
	//strcat(str," thanks");
	strcat(str," \x0A\x0D");
	printf("str is:%s\n",str);
	printf("str length:%d\n",strlen(str));
	write(g_Handle, str, strlen(str));
	free(str);
}


