
#include "MainForm.h"
#include "FloatForm.h"

#include <QApplication>
#include <QSettings>
#include <QDir>
#include <QResource>
#include <QObject>
#include <QDesktopWidget>

//#ifdef Q_OS_LINUX
//    #include <xcb/xcb.h>
//    #include <xcb/sync.h>
//#endif


#include "PreDefined.h"
#include "QsLog/QsLog.h"
#include "NetWork/UdpNotifier.h"
#include "DClasses/DSingleApplication.h"
#include "Util/IniDataManger.h"
#include "SettingForm.h"
#include "PreDefined.h"
#include "Util/BillsManger.h"
#include <QtGlobal>
#include <QTextCodec>
#include <QFont>
#include "Util/sinfoControl.h"
#include "Util/BillsManger.h"
#include "Util/wbillcontrol.h"
#include "XCBOperate.h"

using namespace QsLogging;

int main(int argc, char *argv[])
{
    DSingleApplication a(argc, argv);
    if(a.IsRunning())
    {
        return -1;
    }
    // 获取程序所在目录(不以/结尾)
    QString appDir(a.applicationDirPath());

    QApplication::addLibraryPath(appDir + "/lib");
    // 初始化日志类
    IniDataManger::LogInfo logInfo;
    logInfo = OBJREF(IniDataManger).GetLogInfo();
    Logger& logger = Logger::instance();
    logger.setLoggingLevel((Level)logInfo.level);
    // 定向到日志文件
    QDir().mkdir(appDir+"/logs");
    QString logPath = appDir + "/logs/" + LOG_NAME;
    DestinationPtr fileDestination(DestinationFactory::MakeFileDestination(
    logPath, EnableLogRotation, MaxSizeBytes(logInfo.size*1024*1024), MaxOldLogCount(logInfo.maxcount)));
    logger.addDestination(fileDestination);
    DestinationPtr consoleDestination(DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consoleDestination);


    QLOG_INFO() << QString("==============================fmtakeaway(%1)start==============================").arg(VERSION);

    QFont ft;
    ft.setFamily("WenQuanYi Micro Hei");
    a.setFont(ft);

    // 加载资源文件
    QString strStyleSheet("");
    QString rccPath = QString("%1/Ui/%2.rcc").arg(appDir).arg(OBJREF(IniDataManger).GetTheme());
    qDebug()<<rccPath;
    if(!QFile(rccPath).exists())
    {
        QLOG_WARN() << QString("can't find rcc file![%1]").arg(rccPath);
    }else
    {
        QResource::registerResource(rccPath); 
        QString qssPath = QString(":/%1.qss").arg(OBJREF(IniDataManger).GetTheme());

        QFile qssFile(qssPath);
        if(!qssFile.open(QFile::ReadOnly))
        {
            QLOG_WARN() << QString("can't open skin file![%1]").arg(qssPath);
        }else
        {
            strStyleSheet = qssFile.readAll();
        }
    }
    qApp->setStyleSheet(strStyleSheet);

    WBillControl::GetInstance().SetRemoteInfo(IniDataManger::Instance().GetDbServerUrl());
    // 主界面窗口
    FloatForm f;
    MainForm w;

    XCBOperate oper;
    w.setFloatWId(f.winId());
    QObject::connect(&w, SIGNAL(updateXCB(WId)), &oper, SLOT(update(WId)));

    // 链接信号槽
    QObject::connect(&f, SIGNAL(mainFormShow()), &w, SLOT(onShow()));
    QObject::connect(&f, SIGNAL(bMoved(QPoint)), &w, SLOT(onFloatMoved(QPoint)));
    QObject::connect(&w, SIGNAL(floatFormShow()), &f,SLOT(show()));
    QObject::connect(&w, SIGNAL(floatStopBlink()), &f, SLOT(onStopBlink()));
    QObject::connect(&w, SIGNAL(floatStartBlink(int)), &f, SLOT(onStartBlink(int)));



    SInfoControl::GetInstance().Start(34953);
    QObject::connect(&SInfoControl::GetInstance(), SIGNAL(getNewStoreInfo(QJsonObject)), &BillsManger::Instance(), SLOT(onGetNewStoreInfo(QJsonObject)));

    w.move (0,0);
    oper.update(w.winId());

    w.show();
    w.resize(800,600);
    return a.exec();
}



