#ifndef INIDATAMANGER_H
#define INIDATAMANGER_H

#include <QSettings>
#include <QJsonObject>

class IniDataManger
{
public:
    typedef struct
    {
        QString host;
        QString username;
        QString password;
        QString database;
        int timeout;
    }SqlServerInfo;

    typedef struct
    {
        int size;
        int maxcount;
        int level;
    }LogInfo;

    typedef struct
    {
        QString password;
        QString stationId;
        QString operatorId;
    }LoginInfo;

    typedef struct
    {
        int bProxy;
        QString url;
        QString host;
        int port;
    }FmServerInfo;

    typedef struct
    {
        QString operator_id;
        QString pos_id;
        QString store_id;
        QString partner_id;
        QString business_date;
        QString mates_id;
    }StoreInfo;

public:
    static IniDataManger& Instance();

    StoreInfo GetStoreInfo();
    void SetStoreInfo(StoreInfo storeInfo);
    LogInfo GetLogInfo();
    LoginInfo GetLoginInfo();
    QString GetTheme();
    int GetUdpPort();
    SqlServerInfo GetSqlServerInfo();
    QString GetPrinterName();
    FmServerInfo GetFmServerInfo();
    bool        GetIsExistBtnComplete();
    bool        GetIsExistOperator();
    float       GetBlinkInterval();
    float       GetSoundInterval();
    QPoint      GetFloatPos();

    QString     GetBillFile() const;
    QString     GetViviBillFile() const;
    QJsonObject GetStoreJson();
    QString     GetTillFile();
    QString     GetPOSServerIP();
    QString     GetPOSStoreName();

    bool        GetShowCancel();
    QString     GetStoreIdPrefix();

    QString     GetChannelColor(const QString &channel);
    int         GetNotifyAcceptTimer() const;

    QStringList GetStoreMates();

    int         GetMaxRetry() const;

    void SetSqlServerInfo(const SqlServerInfo&);
    void SetPrinterName(const QString&);

    void SetStoreJson(const QJsonObject&);

    /* 功能:读取服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetDbServerUrl();

    void SetMates(const QStringList& mates);

private:
    IniDataManger();
    IniDataManger(IniDataManger const&);
    IniDataManger& operator=(IniDataManger const&);

    QJsonObject     _GetFileJson(const QString &file);

private:
    QSettings *m_set;
    QSettings *m_userSet;
    QSettings *m_fmps;

    QJsonObject m_storeJson;

    QStringList m_mates;
};

#endif // INIDATAMANGER_H
