#include "SRForm.h"
#include "ui_SRForm.h"
#include <QDebug>

SerachResultForm::SerachResultForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SerachResultForm)
{
    ui->setupUi(this);

    this->hide();

    this->setWindowFlags(Qt::FramelessWindowHint);
    this->setAttribute(Qt::WA_TranslucentBackground);
}

SerachResultForm::~SerachResultForm()
{
    delete ui;
}

void SerachResultForm::iniListWidget(const QStringList &list)
{
    qDebug() << __FUNCTION__;
    ui->searchResultListWdg->clear();

    if(list.isEmpty())
    {
        this->hide();
    }else
    {
        this->show();
        ui->searchResultListWdg->addItems(list);
    }

}

void SerachResultForm::on_searchResultListWdg_itemClicked(QListWidgetItem *item)
{
    this->hide();
    emit currentTextChanged(item->text());
}
