#include "DataObject.h"

DataObject::DataObject(QObject *parent)
    : QObject(parent)
{

}

DataObject::DataObject(const DataObject &p)
{
    const QMetaObject *m = p.metaObject();
    for( int i = m->propertyOffset(); i < m->propertyCount(); i ++){
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property( key.toUtf8());
        this->setProperty( key.toUtf8(),value);
    }
}

void DataObject::fetchDataFromJson(const QJsonObject &json)
{
    QStringList keys = json.keys();
    for (int i = 0; i < keys.count(); i++) {
        this->setProperty(keys.value(i).toUtf8(), json[keys.value(i)].toVariant());
    }
}




DataObject &DataObject::operator =( const DataObject &p)
{
    const QMetaObject *m = p.metaObject();
    DataObject np;
    for( int i = m->propertyOffset(); i < m->propertyCount(); i ++){
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property( key.toUtf8());
        np.setProperty( key.toUtf8(),value);
    }
    return np;
}

bool DataObject::operator ==( const DataObject &p)
{
    const QMetaObject *m = p.metaObject();
    for( int i = m->propertyOffset(); i < m->propertyCount(); i ++){
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant vr = p.property( key.toUtf8());
        QVariant vl = this->property( key.toUtf8());
        if( vl != vr)
            return false;
    }
    return true;
}

/*QJsonObject DataObject::toJson() const
{
    QJsonObject json;
    const QMetaObject *m = metaObject();
    for( int i = m->propertyOffset(); i < m->propertyCount(); i ++){
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant va = property( qmp.name());
        QJsonValue jsonv = QJsonValue::fromVariant( va);
        json.insert( key, jsonv);
    }
    return json;
}*/

