#include "qrichbutton.h"
#include <QPainter>
#include <QStylePainter>
#include <QVariant>
#include <QTextDocument>
#include <QStyleOptionButton>
#include <QDebug>

QRichButton::QRichButton(QWidget *parent) :
    QPushButton(parent),
    _rich_enabled(false),
    _counter(0)
{
}

void QRichButton::setHtml(const QString &html)
{
    _html = html;
}

void QRichButton::setEnableRich(bool enabled)
{
    _rich_enabled = enabled;
}

void QRichButton::setCounter(int n)
{
    _counter = n;
    update();
}

void QRichButton::paintEvent(QPaintEvent *pe)
{
    if (_rich_enabled && _counter > 0) {
        QStylePainter sp(this);
        QStyleOptionButton opt;
        initStyleOption(&opt);
        sp.drawControl(QStyle::CE_PushButton, opt);

        QFontMetrics fm = opt.fontMetrics;
        int y = height() - (height() - fm.height()) / 2.0;
        y -= (fm.descent() + 1);
        int x = (width() - fm.width(text())) / 2 + fm.width(property("name").toString());
        sp.setPen(QColor(Qt::red));
        sp.drawText(x, y, QString("(%1)").arg(_counter));
    }
    else {
        QPushButton::paintEvent(pe);
    }
}
