#ifndef NOTIFYFORM_H
#define NOTIFYFORM_H

#include <QDialog>
#include <QTimeLine>

#define COUNTDOWN_TIME 3

namespace Ui {
class NotifyForm;
}

class NotifyForm : public QDialog
{
    Q_OBJECT

public:
    // 窗口类型
    enum Type{OK=0, ERROR, LOADING};

    /* 功能: 显示提示窗
     * 参数: [1]信息 [2]窗口类型
     * 返回: NULL
     * */
    explicit NotifyForm(QString, NotifyForm::Type, QWidget*);
    ~NotifyForm();

    void     SetAutoClose(int seconds = 5);
    void     SetExtraInfo(const QString &tip);

private:
    /* 功能: 初始化界面
     * 参数: [1]显示内容[2]窗口类型
     * 返回: NULL
     * */
    void _Init(QString, NotifyForm::Type);

private:
    Ui::NotifyForm *ui;

    // 动画对象
    QMovie *m_movie;

    QTimeLine m_ac_timeline;
    QString   m_btn_text;
private slots:
    /* 功能: 更改状态
     * 参数: [1]信息 [2]类型
     * 返回: NULL
     * */
    void onChangeType(QString, NotifyForm::Type);

    void on_notifyBtnOk_clicked();

    void onCountDown(int frame);
};

#endif // NOTIFYFORM_H
