#ifndef FLOATFORM_H
#define FLOATFORM_H

#include <QDialog>
//#include <QSound>
#include <QPropertyAnimation>

namespace Ui {
class FloatForm;
}

class FloatForm : public QDialog
{
    Q_OBJECT

public:
    explicit FloatForm(QWidget *parent = 0);
    ~FloatForm();

public slots:
    void onStartBlink(int table_id);
    void onStopBlink();
    void onShowFloatWnd();

private:
    Ui::FloatForm *ui;

    // 音频定时器
    QTimer *m_soundTimer;
    // 置顶定时器
    QTimer *m_raiseTimer;
    // 闪烁定时器
    QTimer *m_blinkTimer;
    // 记录是闪烁状态
    bool m_bBlink;
    // 闪烁动画
    QPropertyAnimation *m_animation;

    //QSound *m_sound;
    int m_soundIndex;
    QSize m_imgNormal;
    QSize m_imgNotifyNew;

    QString     _qss_notify_normal;
    QString     _qss_notify_new;
    QString     _qss_notify_mates;
    QString     _qss_notify_refund;
    int         _vid;

private slots:
    void onSoundTimeOut();
    void onBlinkTimerOut();
    void on_floatBtnLogo_clicked();

signals:
    void mainFormShow();
    void bMoved(QPoint);
};

#endif // FLOATFORM_H
