#ifndef FMTAKEAWAY_PRINTER_H
#define FMTAKEAWAY_PRINTER_H

#include "fmtakeaway_printer_global.h"
#include <QObject>
#include "../fmTakeaway/DataObject/OrderObject.h"
#include <QLibrary>

class FMTAKEAWAY_PRINTERSHARED_EXPORT FmTakeaway_printer : public QObject
{
    Q_OBJECT
public:
    static FmTakeaway_printer& Instance();

    /* 功能:打印订单
     * 参数:[1]物理打印机名[2]订单对象
     * 返回:true成功false失败
     * */
    bool DoPrint(QString printerName, OrderObject *pData);
    /* 功能:打印测试
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:true成功false失败
     * */
    bool TestPrint(QString printerName, QString data);
    void setStoreName(QString name);

    /* 功能:从订单对象获取打印数据
     * 参数:[1]订单对象
     * 返回:打印数据
     * */
    QString _GetPrintData(OrderObject* pData);
    int printsize;

private:
    QString storename;
    FmTakeaway_printer();
    FmTakeaway_printer(FmTakeaway_printer const&);
    FmTakeaway_printer& operator=(FmTakeaway_printer const&);


    /* 功能:打印数据
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:打印数据
     * */
    bool _RawDataToPrinter(QString printerName, QString data);

    typedef bool ( *OpenPrinter)( void);
    typedef void ( *InitPrinter)( char str[]);
    typedef void ( *PrintText)( char str[]);
    typedef void ( *ClosePrinter)(void);
    typedef bool ( *LoadAddress)(void);
    typedef int  (*Total)(int);

    int total;
    QLibrary m_print_lib;
    bool m_b_load_sucfl;
    OpenPrinter f_OpenPrinter;
    InitPrinter f_InitPrinter;
    PrintText f_PrintText;
    ClosePrinter f_ClosePrinter;
    LoadAddress f_LaodAddress;
    Total f_total;
    QString _Penny2Dollar(int penny);

};

#endif // FMTAKEAWAY_PRINTER_H
