#ifndef DMVBUTTON_H
#define DMVBUTTON_H

#include <QPushButton>
#include <QMouseEvent>
#include <QWidget>
#include <QTimer>

class DMvButton : public QPushButton
{
    Q_OBJECT
public:
    explicit DMvButton(QWidget *parent);

protected:
    void mouseMoveEvent(QMouseEvent * e);
    void mousePressEvent(QMouseEvent * e);
    void mouseReleaseEvent(QMouseEvent * e);

private:
    bool m_bMouseMove;
    bool m_bMousePress;
    QPoint m_lastMousePos;
    QWidget * m_parent;
    QPoint m_absMove;

signals:
    void bMoved(QPoint);
};

#endif // DMVBUTTON_H
