#ifndef WBILLCONTROL_H
#define WBILLCONTROL_H

#include <QtSql/QSqlDatabase>
#include <QDateTime>
#include <QThread>
#include <QTcpServer>
#include <QMap>
#include "DataObject/OrderObject.h"

typedef struct {
    int flag;
    int ver;
    int len;
}FMSOCKEHEADER;

struct PrinterMenu
{
    QString strMenuId;           //菜品ID
    QString strMenuName;         //菜品名称
    int     iPrinterId;          //打印机ID(厨房)
    QString strDevice;           //打印机端口(厨房)
    int     iBaud;               //波特率(厨房)
    QString strTitle;            //打印标题(厨房)
    int     iOrderPrinterId;     //打印机ID(上菜单)
    QString strOrderDevice;      //打印机端口(上菜单)
    int     iOrderBaud;          //波特率(上菜单)
    QString strOrderTitle;       //打印标题(上菜单)
};

struct SetMenuItem
{
    QString strMenuId;           //菜品id
    int     num;                 //数量
};

class WBillControl : public QObject
{
    Q_OBJECT
public:
    static WBillControl& GetInstance();

    /* 功能:设置销售单写入远程地址
     * 参数:[1]远程地址
     * 返回:NULL
     * */
    void SetRemoteInfo(const QString& url);
    /* 功能:设置门店信息
     * 参数:[1]门店号、收银员号、POS号、营业日
     * 返回:NULL
     * */
    void SetStoreInfo(const QString& partner_id, const QString& storeId, const QString& operaId, const QString& posId, const QString& dbusiness);

public slots:
    /* 功能:写入销售单
     * 参数:[1]订单对象[2]错误信息[3]是否是确认动作
     * 返回:是否成功
     * */
    void DoOrderEntry(OrderObject const *orderObject);
    /* 功能:撤销销售单
     * 参数:[1]订单编号[2]错误信息
     * 返回:是否成功
     * */
    void RefundOrder(const QString& orderId);

    //打印小票
    void PrintLable(const OrderObject *obj);

private:
    /* 功能:获取写入销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray GetOrderEntryData(OrderObject const *orderObject, bool bVerify = false);
    /* 功能:获取撤销销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray GetRefundOrderData(const QString& fmId);

    /* 功能:销售单数据发送给monitor
     * 参数:[1]订单数据
     * 返回:发送结果
     * */
    bool SendToMonitor(const QByteArray &data,QTcpSocket *pSocket);

    void GetPosMenu();

    void setMenu(const QByteArray &JsonMenu);

    int charset_convert(const char* charset_from, const char* charset_to
                        , const std::string& string_from, std::string& string_to);

    /* 功能:utf8转GB18030
     * 参数:[1]utf8字符
     * 返回:GB18030字符
     * */
    std::string charset_u2g(const std::string& utf8);

    /* 功能:厨房单打印
     * 参数:[1]订单信息
     * 参数:[2]菜单id
     * 参数:[3]数量
     * 参数:[4]打印跳转
     * 返回:
     * */
    void printCook(const OrderObject *obj,const QString& menuId,int num,bool bJump=false);

    //外卖单打印
    void printTakeout(const OrderObject *obj);

    //上菜单打印
    void printMenu(const OrderObject *obj);

    //收银账单打印
    void printBill(const OrderObject *obj);

    //厨房小票信息发送到monitor
    bool sendToPrintServer(QByteArray &JsonPrint);

    //上菜单打印
    QString getPrintTitle(const QString& channel,int index);

public:
    QVector<PrinterMenu> vecMenu;
    QMap<QString,QVector<SetMenuItem>> mapSetMenu;
private:
    WBillControl();
    ~WBillControl();
    WBillControl(WBillControl const&);
    WBillControl& operator=(WBillControl const&);

    // 通信地址
    QString m_host;

    // 门店号、收银员号、POS号、营业日
    QString m_partner_id;
    QString m_storeId;
    QString m_operatorId;
    QString m_posId;
    QString m_dbusiness;

    // 订单对象
    OrderObject const *m_orderObject;
signals:
    // 更新list入库显示
    void sUpdatePosRes(const OrderObject *order);
};

#endif // WBILLCONTROL_H
