#ifndef SINFOCONTROL_H
#define SINFOCONTROL_H

#include <QObject>
#include <QThread>
#include <QTcpServer>
#include <QTcpSocket>

class SInfoControl : public QThread
{
    Q_OBJECT
public:
    static SInfoControl& GetInstance();

    /* 功能:开启监听服务
     * 参数:[1]端口号
     * 返回:NULL
     * */
    void Start(int port);

protected:
    void run();

private:
    SInfoControl(): m_port(-1),m_bQuit(false){}
    ~SInfoControl();
    SInfoControl(SInfoControl const&);
    SInfoControl& operator=(SInfoControl const&);

    /* 功能:处理获取到门店信息
     * 参数:[1]获取到的Json数据[2]返回的处理状态[3]返回的消息
     * 返回:NULL
     * */
    void _ProcessCmdStoreInfo(const QJsonObject&, QString&, QString&);
    void _GetLocalStoreInfo();

    QTcpServer *m_tcpServer;
    QTcpSocket *m_tcpSocket;
    int m_port;
    bool m_bQuit;


signals:
    /* 功能:通知主界面监听失败
     * 参数:[1]失败信息
     * 返回:NULL
     * */
    void listenFailed(const QString& error);

    /* 功能:通知获取到门店信息
     * 参数:[1]json数据
     * 返回:NULL
     * */
    void getNewStoreInfo(const QJsonObject&);
};

#endif // SINFOCONTROL_H
