#include "SettingForm.h"
#include "ui_SettingForm.h"
#include "PreDefined.h"
#include "../../fmTakeaway_db/FmTakeaway_db.h"
#include "Util/IniDataManger.h"
#include "QsLog/QsLog.h"
#include <QStringList>
#include <QMovie>

SettingForm::SettingForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingForm)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint);

    // 初始化控件
    ui->settingLabError->hide();
    m_movie = new QMovie(this);
    m_movie->setFileName(":/images/load.gif");
    ui->settingLabMov->setMovie(m_movie);
    ui->settingLabMov->setScaledContents(true);
    m_movie->start();
    ui->settingLabMov->hide();

    // 初始化数据库信息
    IniDataManger::SqlServerInfo sqlInfo;
    sqlInfo = OBJREF(IniDataManger).GetSqlServerInfo();
    ui->settingEdtHost->setText(sqlInfo.host);
    ui->settingEdtUsername->setText(sqlInfo.username);
    ui->settingEdtPassword->setText(sqlInfo.password);
    ui->settingEdtDatabase->setText(sqlInfo.database);

    QObject::connect(&FmTakeaway_db::Instance(), SIGNAL(failed()), this, SLOT(onConnectFailed()));
    QObject::connect(&FmTakeaway_db::Instance(), SIGNAL(successful()), this, SLOT(onConnectSucessful()));

    on_settingBtnOk_clicked();
}

SettingForm::~SettingForm()
{
    delete ui;
}

void SettingForm::_SetSubControlEnable(bool bEnable)
{
    ui->settingBtnOk->setEnabled(bEnable);
    ui->settingBtnCancle->setEnabled(bEnable);
    ui->settingEdtUsername->setEnabled(bEnable);
    ui->settingEdtHost->setEnabled(bEnable);
    ui->settingEdtPassword->setEnabled(bEnable);
    ui->settingEdtDatabase->setEnabled(bEnable);
    return;
}

void SettingForm::on_settingBtnOk_clicked()
{
    QLOG_TRACE() << __FUNCTION__;
    ui->settingLabError->hide();

    if(ui->settingEdtHost->text().isEmpty() ||
       ui->settingEdtUsername->text().isEmpty() ||
       ui->settingEdtDatabase->text().isEmpty())
    {
        ui->settingLabError->setText("请输入正确信息!");
        ui->settingLabError->show();
        return;
    }

    ui->settingLabMov->show();
    _SetSubControlEnable(false);
    FmTakeaway_db::Instance().Connect(ui->settingEdtHost->text(),
                                      ui->settingEdtDatabase->text(),
                                      ui->settingEdtUsername->text(),
                                      ui->settingEdtPassword->text(),
                                      OBJREF(IniDataManger).GetSqlServerInfo().timeout);
    QLOG_INFO() << QString("connect sqlserver.[%1]").arg(FmTakeaway_db::Instance().GetConnectInfo());
    return;
}

void SettingForm::on_settingBtnCancle_clicked()
{
    QLOG_TRACE() << __FUNCTION__;
    this->reject();
    return;
}

void SettingForm::onConnectSucessful()
{
    QLOG_INFO() << QString("connect sqlserver sucessful.");
    // 数据库信息有效,存入配置文件
    IniDataManger::SqlServerInfo sqlInfo;
    sqlInfo.host = ui->settingEdtHost->text();
    sqlInfo.username = ui->settingEdtUsername->text();
    sqlInfo.password = ui->settingEdtPassword->text();
    sqlInfo.database = ui->settingEdtDatabase->text();
    OBJREF(IniDataManger).SetSqlServerInfo(sqlInfo);

    this->accept();
    return;
}

void SettingForm::onConnectFailed()
{
    QLOG_WARN() << QString("connect sqlserver falied.[error:%1]").arg(FmTakeaway_db::Instance().GetLastError());
    ui->settingLabError->setText("连接数据库失败!");
    ui->settingLabError->show();
    ui->settingLabMov->hide();
    _SetSubControlEnable(true);
    return;
}
