#ifndef DATAOBJECT_H
#define DATAOBJECT_H

#include <QObject>

#include <QtGlobal>
#if QT_VERSION > QT_VERSION_CHECK(5, 0, 0)
#  include <QJsonObject>
#else
#  include <qjson/parser.h>
#  include <qjson/serializer.h>
#endif

#include <QStringList>
#include <QVariant>
#include <QMetaProperty>

class DataObject : public QObject
{
    Q_OBJECT
public:
    explicit DataObject(QObject *parent = 0);
    DataObject( const DataObject& p);

#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
    void fetchDataFromJson(const QJsonObject & json);
#else
    void fetchDataFromJson(const QVariantMap &json);
#endif

    DataObject &operator = (const DataObject & p);
    bool operator == (const DataObject & p);

#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
    QJsonObject toJson() const
    {
        QJsonObject json;
#else
    QVariantMap toJson() const
    {
        QVariantMap json;
#endif
        const QMetaObject *m = metaObject();
        for( int i = m->propertyOffset(); i < m->propertyCount(); i ++){
            QMetaProperty qmp = m->property(i);
            QString key = QString::fromLatin1(qmp.name());
            QVariant va = property( qmp.name());
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
            QJsonValue jsonv = QJsonValue::fromVariant( va);
            json.insert( key, jsonv);
        }
#else
            json.insert(key, va);
#endif
        return json;
    }
};

#endif // DATAOBJECT_H
