#ifndef WBILLCONTROL_H
#define WBILLCONTROL_H

#include <QtSql/QSqlDatabase>
#include <QDateTime>
#include <QThread>
#include <QTcpServer>
#include "DataObject/OrderObject.h"

typedef struct {
    int flag;
    int ver;
    int len;
}FMSOCKEHEADER;

class WBillControl : public QObject
{
    Q_OBJECT
public:
    static WBillControl& GetInstance();

    /* 功能:设置销售单写入远程地址
     * 参数:[1]远程地址
     * 返回:NULL
     * */
    void SetRemoteInfo(const QString& url);
    /* 功能:设置门店信息
     * 参数:[1]门店号、收银员号、POS号、营业日
     * 返回:NULL
     * */
    void SetStoreInfo(const QString& partner_id, const QString& storeId, const QString& operaId, const QString& posId, const QString& dbusiness);

public slots:
    /* 功能:写入销售单
     * 参数:[1]订单对象[2]错误信息[3]是否是确认动作
     * 返回:是否成功
     * */
    void DoOrderEntry(OrderObject const *orderObject);
    /* 功能:撤销销售单
     * 参数:[1]订单编号[2]错误信息
     * 返回:是否成功
     * */
    void RefundOrder(const QString& orderId);

private:
    /* 功能:获取写入销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray GetOrderEntryData(OrderObject const *orderObject, bool bVerify = false);
    /* 功能:获取撤销销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray GetRefundOrderData(const QString& fmId);

    /* 功能:销售单数据发送给monitor
     * 参数:[1]订单数据
     * 返回:发送结果
     * */
    bool SendToMonitor(const QByteArray &data,QTcpSocket *pSocket);
private:
    WBillControl();
    ~WBillControl();
    WBillControl(WBillControl const&);
    WBillControl& operator=(WBillControl const&);

    // 通信地址
    QString m_host;

    // 门店号、收银员号、POS号、营业日
    QString m_partner_id;
    QString m_storeId;
    QString m_operatorId;
    QString m_posId;
    QString m_dbusiness;

    // 订单对象
    OrderObject const *m_orderObject;
signals:
    // 更新list入库显示
    void sUpdatePosRes(const OrderObject *order);

};

#endif // WBILLCONTROL_H
