#include "RejectForm.h"
#include "ui_RejectForm.h"

RejectForm::RejectForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RejectForm)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint|Qt::Dialog);

    this->move(parent->pos().x()+(parent->width()-this->width())/2,
               parent->pos().y()+(parent->height()-this->height())/2);

    m_rejectReason = 5;
    ui->rejectRbtn0->toggle();
}

RejectForm::~RejectForm()
{
    delete ui;
}

int RejectForm::GetReasonCode()
{
    return m_rejectReason;
}

void RejectForm::on_rejectBtnOk_clicked()
{
    this->accept();
}

void RejectForm::on_rejectBtnCancle_clicked()
{
    this->reject();
}

void RejectForm::on_rejectRbtn0_toggled(bool)
{
    m_rejectReason = 5;
}

void RejectForm::on_rejectRbtn1_toggled(bool)
{
    m_rejectReason = 6;
}

void RejectForm::on_rejectRbtn2_toggled(bool)
{
    m_rejectReason = 1;
}

void RejectForm::on_rejectRbtn3_toggled(bool)
{
    m_rejectReason = 2;
}
