#ifndef MAINFORM_H
#define MAINFORM_H

#include <QWidget>
#include <QPushButton>
#include <QTableWidget>
#include <QPropertyAnimation>
#include "Util/BillsManger.h"
#include "../fmTakeaway_db/FmTakeaway_db.h"
#include "qrichbutton.h"
#include "sysTray.h"

namespace Ui {
class MainForm;
}

class MainForm : public QWidget
{
    Q_OBJECT

public:
    explicit MainForm(QWidget *parent = 0);
    ~MainForm();

private:
    void _InitUI();
    void _InitData();
    // 设置表单是否可排序(用于插入数据的时候须将表单设为不可排序否则会有未知错误.PS:文档是这么说的)
    void _SetTablesSortingEnable(bool bEnable);
    // 根据状态获取对应的表单
    QTableWidget* _GetTableByVID(int vid);
    // 根据状态获取对应的表单按钮
    QRichButton *_GetTableBtnByVID(int vid);
    bool _CheckState();

private:
    Ui::MainForm *ui;
    // 记录上一次选中的表单和按钮
    QPushButton *m_prevTableBtn;
    QTableView *m_prevTable;
    // 时钟定时器
    QTimer m_timeTimer;
    // 记录是否存在详单页面和正在处理的提示框
    bool m_bexistDetailsForm;
    bool m_bLoading;
    // 浮动窗的坐标
    QPoint m_floatPos;
    // 属性动画对象
    QPropertyAnimation *m_anmGeometry;
    QPropertyAnimation *m_anmOpacity;
    // 记录窗体的大小和位置
    QSize m_size;
    QPoint m_pos;
    // 记录当前显示的表
    QTableWidget *m_curtTable;

    int             m_refundCnt;
    int             m_unmateCnt;

    SysTray m_sysTray;

    WId floatWId;

public slots:
    void onBeSlave();
    void onError(const QString& msg, BillsManger::ErrorType type);
    void onPullOrdersError(const QString& msg, BillsManger::ErrorType type);
    void onSucessful(const QString& msg, const QString &extra);
    void onOrderTableChanged(int last, int curr, OrderObject *orderObj);

    void onFloatMoved(QPoint);
    void onShow();

    void onChangeStatus(QString text);
    void setFloatWId(WId id);
private slots:
    void on_btnHide_clicked();
    void on_btnChangeCurOpe_clicked();
    void on_btnChangeMsState_toggled(bool);
    void on_btnTestPrint_clicked();
    void onTableBtnClicked();
    void onOperaBtnClicked();
    void onTimeTimerOut();
    void onTableItemClicked(QTableWidgetItem * item);
    void on_btnScroUp_clicked();
    void on_btnScroDown_clicked();

    void on_cbxPrinter_currentIndexChanged(const QString &text);

    void onOrderMateChanged(const QString &order_id);
    void on_ClearTable();

signals:
    void floatFormShow();
    void floatStartBlink(int table_id);
    void floatStopBlink();
    void ntFormClose();

    void operatorChanged(const FmTakeaway_db::OperatorInfo&);
    void updateXCB(WId);
};

#endif // MAINFORM_H
