#ifndef DETAILSFORM_H
#define DETAILSFORM_H

#include <QDialog>
#include "DataObject/OrderObject.h"
#include "DataObject/ComdObject.h"
#include "Util/BillsManger.h"

namespace Ui {
class DetailsForm;
}

class QTreeWidgetItem;

class DetailsForm : public QDialog
{
    Q_OBJECT

public:
    explicit DetailsForm(OrderObject *orderObj, QWidget *parent = 0);
    ~DetailsForm();

private:
    Ui::DetailsForm *ui;
    OrderObject *m_orderObj;

private:
    void                _InitUi();
    bool                _ReadBilledMates();
    void                _GetMatesSelection(QTreeWidgetItem *item, QList<ComdObject*> &selected, QList<ComdObject*> &unselected);
    void                _AssignMate(QTreeWidgetItem *parent, ComdObject *child);
    void                _UnassignMate(QTreeWidgetItem *parent, ComdObject *child);

    void                _TableInsert(ComdObject *obj);
    void                _TableUpdate(ComdObject *obj);
    void                _TableUpdateChild(ComdObject *parent, ComdObject *child);
    void                _TableSetChild(QTreeWidgetItem *parent, ComdObject *child);

    QTreeWidgetItem*    _TableFindItem(const ComdObject *obj);
    ComdObject *        _ItemToObject(const QTreeWidgetItem *item);
    ComdObject *        _LoneObjectByName(const QString &name, const QString &props);

private slots:
    void        on_detailsBtn0_clicked();
    void        on_detailsBtn1_clicked();
    void        on_detailsBtn2_clicked();
    void        on_detailsBtnClose_clicked();

    void        onItemClicked(QTreeWidgetItem *item, int col);
    void        onError(const QString& msg, BillsManger::ErrorType type);
    void        onSucessful(const QString& msg, const QString &extra);

    void on_detailsBtn3_clicked();

signals:
    void        ntFormClose();
    void        orderMateChanged(const QString &order_id);
};

#endif // DETAILSFORM_H
