#ifndef DSINGLEAPPLICATION_H
#define DSINGLEAPPLICATION_H

#include <QApplication>
#include <QLocalSocket>
#include <QLocalServer>

class DSingleApplication : public QApplication
{
    Q_OBJECT
public:
    explicit DSingleApplication(int &argc, char **argv);

    /* 功能:判断是否有实例在运行
     * 参数:NULL
     * 返回:true有 false无
     * */
    bool IsRunning();
    /* 功能:设置主窗口句柄
     * 参数:主窗口句柄
     * 返回:NULL
     * */
    void SetMainForm(QWidget* pMainForm);

private slots:
    // 有新连接时触发
    void _onNewLocalConnection();

private:
    // 初始化本地连接
    void _InitLocalConnection();
    // 创建服务端
    void _NewLocalServer();
    // 激活窗口
    void _ActivateWindow();

    QWidget *m_pMainForm;            // 主窗口句柄
    bool m_isRunning;                // 是否已经有实例在运行
    QLocalServer *m_localServer;     // 本地socket Server
    QString m_serverName;            // 服务名称
};

#endif // DSINGLEAPPLICATION_H
