#!/bin/bash
CMDName="/home/czl/monitor/bin/monitor"
PIDFile="/home/czl/monitor/bin/pidMonitor.txt"
# ---------------------------------------------------
# 启动函数
function startClient {
    $CMDName  2>&1 &
    mypgmpid=$!
    echo $mypgmpid > $PIDFile
    echo "startClient [ok]"
}
# 停止函数
function stopClient {
    kill `cat $PIDFile`
    rm $PIDFile
    echo "stopClient [ok]"
}
# --------------------------------------------------
echo "$CMDName $1"
case "$1" in
start)
    if [ -f $PIDFile ] ; then
        stopClient
        sleep 4
    fi
    startClient
;;
restart)
    if [ -f $PIDFile ] ; then
        stopClient
        sleep 4
    fi
    startClient
;;
stop)
    stopClient
    exit 0
;;
esac
for (( c=0 ; ; c++ ))
do
    if [ -f $PIDFile ] ; then
        mypgmpid=`cat $PIDFile`
        cmdex="ps uh -p$mypgmpid"
        psrtn=`$cmdex`
        if [ -z "$psrtn" ]; then
            # 进程挂掉自动重启
            echo "`date '+%Y/%m/%d %H:%M:%S'` FATALERROR RESTART SERVICE"
            startClient
        elif (( $c%20 == 0 )); then
            # 记录进程运行状态
            echo "`date '+%Y/%m/%d %H:%M:%S'` PSINFO $psrtn" 
            c=0
        fi
        sleep 3 
    else
        break
    fi
done
